/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.core.lightning;

import java.util.ArrayDeque;
import java.util.Deque;
import net.labymod.addons.flux.core.Flux;
import net.labymod.addons.flux.core.configuration.FluxConfiguration;
import net.labymod.addons.flux.core.configuration.lightning.LightningConfiguration;
import net.labymod.addons.flux.core.lightning.UnloadStrategy;

public class LightningUpdateQueue {
    private final Deque<Runnable> lightUpdateQueue = new ArrayDeque<Runnable>();

    public void queueLightUpdate(Runnable task) {
        FluxConfiguration config = (FluxConfiguration)Flux.get().configuration();
        LightningConfiguration lightning = config.lightning();
        if (((Boolean)config.enabled().get()).booleanValue() && lightning.chunkUnloadStrategy().get() == UnloadStrategy.QUEUE) {
            this.lightUpdateQueue.add(task);
        } else {
            task.run();
        }
    }

    public void pollLightUpdates() {
        Runnable task;
        int size = this.lightUpdateQueue.size();
        int updates = size < 1000 ? Math.max(10, size / 10) : size;
        for (int i = 0; i < updates && (task = this.lightUpdateQueue.poll()) != null; ++i) {
            task.run();
        }
    }
}

