/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.core.renderer;

import java.util.Locale;
import java.util.function.Function;
import net.labymod.addons.flux.core.renderer.world.cloud.CloudRenderPass;
import net.labymod.api.Laby;
import net.labymod.api.laby3d.pipeline.RenderStates;
import net.labymod.api.laby3d.vertex.VertexDescriptions;
import net.labymod.api.util.function.FunctionMemoizeStorage;
import net.labymod.laby3d.api.pipeline.ComparisonStrategy;
import net.labymod.laby3d.api.pipeline.DrawingMode;
import net.labymod.laby3d.api.pipeline.RenderState;
import net.labymod.laby3d.api.pipeline.blend.DefaultBlendFunctions;
import net.labymod.laby3d.api.pipeline.shader.ShaderProgramDescription;
import net.labymod.laby3d.api.pipeline.shader.UniformSamplerDescription;
import net.labymod.laby3d.api.resource.AssetId;

public final class FluxRenderStates {
    private static final FunctionMemoizeStorage MEMOIZE_STORAGE = Laby.references().functionMemoizeStorage();
    private static final Function<String, AssetId> SHADER_RESOLVER = path -> AssetId.of((String)"flux", (String)("shaders/" + path));
    private static final Function<CloudRenderPass, RenderState> CLOUD_PROGRAM = MEMOIZE_STORAGE.memoize(renderPass -> {
        RenderState.Builder builder = RenderState.builder((RenderState.Snippet[])new RenderState.Snippet[0]);
        String id = "cloud_program" + renderPass.name().toLowerCase(Locale.ROOT);
        builder.setId(FluxRenderStates.buildId(id)).setVertexDescription(VertexDescriptions.POSITION_UV_COLOR_NORMAL).setDrawingMode(DrawingMode.QUADS).setCull(false).setBlendFunction(DefaultBlendFunctions.TRANSLUCENT).setDepthTestStrategy(ComparisonStrategy.LEQUAL).setAlphaTestStrategy(ComparisonStrategy.GREATER).setAlphaTestReference(0.5f);
        switch (renderPass) {
            case COLOR: {
                builder.setWriteColor(true);
                break;
            }
            case DEPTH: {
                builder.setWriteColor(false);
            }
        }
        builder.setShaderProgramDescription(ShaderProgramDescription.builder((ShaderProgramDescription.Snippet[])new ShaderProgramDescription.Snippet[]{RenderStates.DEFAULT_SHADER_SNIPPET}).setId(FluxRenderStates.buildProgramId(id)).setFragmentShader(SHADER_RESOLVER.apply("cloud/cloud.fsh")).setVertexShader(SHADER_RESOLVER.apply("cloud/cloud.vsh")).addSampler(new UniformSamplerDescription("DiffuseSampler", 0)).build());
        return builder.build();
    });

    public static RenderState cloud(CloudRenderPass renderPass) {
        return CLOUD_PROGRAM.apply(renderPass);
    }

    private static AssetId buildId(String path) {
        return AssetId.of((String)"flux", (String)("state/" + path));
    }

    private static AssetId buildProgramId(String path) {
        return AssetId.of((String)"flux", (String)("program/" + path));
    }
}

