/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.core.renderer.world.cloud;

import net.labymod.addons.flux.core.configuration.FluxConfiguration;
import net.labymod.addons.flux.core.renderer.FluxRenderStates;
import net.labymod.addons.flux.core.renderer.world.cloud.CloudRenderPass;
import net.labymod.api.Laby;
import net.labymod.api.client.gfx.pipeline.renderer.mesh.MeshRenderer;
import net.labymod.api.client.gfx.shader.ShaderTextures;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.laby3d.Laby3D;
import net.labymod.api.laby3d.shaders.block.DynamicTransformsUniformBlockData;
import net.labymod.api.util.math.MathHelper;
import net.labymod.laby3d.api.RenderDevice;
import net.labymod.laby3d.api.buffers.BufferBuilder;
import net.labymod.laby3d.api.mesh.GeometryData;
import net.labymod.laby3d.api.mesh.Mesh;
import net.labymod.laby3d.api.pipeline.RenderState;
import net.labymod.laby3d.api.shaders.block.UniformBlockData;
import net.labymod.laby3d.api.vertex.VertexConsumer;
import org.joml.Matrix4fc;

public final class CloudRenderer {
    private static final ResourceLocation CLOUDS_LEGACY = ResourceLocation.create((String)"minecraft", (String)"textures/environment/clouds.png");
    private static final float MOJANG_CLOUD_OFFSET = 9.765625E-4f;
    private static final float UV_OFFSET = 0.00390625f;
    private static final float CLOUD_SCALE = 12.0f;
    private final FluxConfiguration configuration;
    private Mesh cloudMesh;
    private int previousCloudX = Integer.MIN_VALUE;
    private int previousCloudY = Integer.MIN_VALUE;
    private int previousCloudZ = Integer.MIN_VALUE;
    private float previousCloudRed = 1.0f;
    private float previousCloudGreen = 1.0f;
    private float previousCloudBlue = 1.0f;
    private double camX;
    private double camY;
    private double camZ;
    private int ticks;
    private boolean buildGeometry = true;

    public CloudRenderer(FluxConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isEnabled() {
        return (Boolean)this.configuration.enabled().get() != false && (Boolean)this.configuration.world().bufferedClouds().get() != false;
    }

    public CloudRenderer setTicks(int ticks) {
        this.ticks = ticks;
        return this;
    }

    public CloudRenderer setPosition(double x, double y, double z) {
        this.camX = x;
        this.camY = y;
        this.camZ = z;
        return this;
    }

    public void render(Stack stack, float partialTicks, float cloudHeight, float red, float green, float blue) {
        int cloudZ;
        int cloudY;
        if (Float.isNaN(cloudHeight)) {
            return;
        }
        float animationProgress = ((float)this.ticks + partialTicks) * 0.03f;
        double x = (this.camX + (double)animationProgress) / 12.0;
        double y = (double)cloudHeight - this.camY + (double)0.33f;
        double z = this.camZ / 12.0 + (double)0.33f;
        x -= (double)(MathHelper.floor((double)(x / 2048.0)) * 2048);
        z -= (double)(MathHelper.floor((double)(z / 2048.0)) * 2048);
        double worldX = x - (double)MathHelper.floor((double)x);
        double worldY = (y / 4.0 - (double)MathHelper.floor((double)(y / 4.0))) * 4.0;
        double worldZ = z - (double)MathHelper.floor((double)z);
        int cloudX = (int)Math.floor(x);
        if (!this.isSameCloudPosition(cloudX, cloudY = (int)Math.floor(y / 4.0), cloudZ = (int)Math.floor(z)) || !this.isSameCloudColor(red, green, blue)) {
            this.previousCloudX = cloudX;
            this.previousCloudY = cloudY;
            this.previousCloudZ = cloudZ;
            this.previousCloudRed = red;
            this.previousCloudGreen = green;
            this.previousCloudBlue = blue;
            this.buildGeometry = true;
        }
        Laby3D laby3D = Laby.references().laby3D();
        if (this.buildGeometry) {
            this.buildGeometry = false;
            RenderState renderState = FluxRenderStates.cloud(CloudRenderPass.COLOR);
            BufferBuilder bufferBuilder = laby3D.begin(renderState.drawingMode(), renderState.vertexDescription());
            this.buildCloudGeometry((VertexConsumer)bufferBuilder, x, y, z, red, green, blue);
            GeometryData geometryData = bufferBuilder.build();
            if (geometryData == null) {
                this.buildGeometry = true;
                return;
            }
            if (this.cloudMesh != null) {
                try {
                    this.cloudMesh.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cloudMesh = Mesh.create((RenderDevice)laby3D.renderDevice(), () -> "Clouds", (GeometryData)geometryData);
        }
        if (this.cloudMesh == null) {
            return;
        }
        stack.push();
        stack.scale(12.0f, 1.0f, 12.0f);
        stack.translate(-worldX, worldY, -worldZ);
        ShaderTextures.setShaderTexture((int)0, (ResourceLocation)CLOUDS_LEGACY);
        for (int renderPass = 0; renderPass < 2; ++renderPass) {
            CloudRenderPass cloudRenderPass = renderPass == 0 ? CloudRenderPass.DEPTH : CloudRenderPass.COLOR;
            MeshRenderer.draw((Mesh)this.cloudMesh, (RenderState)FluxRenderStates.cloud(cloudRenderPass), command -> {
                DynamicTransformsUniformBlockData data = new DynamicTransformsUniformBlockData();
                data.modelViewMatrix().set((Matrix4fc)stack.getProvider().getPose());
                command.setUniformBlockData("DynamicTransforms", (UniformBlockData)data);
            });
        }
        stack.pop();
    }

    private boolean isSameCloudPosition(float x, float y, float z) {
        return x == (float)this.previousCloudX && y == (float)this.previousCloudY && z == (float)this.previousCloudZ;
    }

    private boolean isSameCloudColor(float x, float y, float z) {
        return x == this.previousCloudRed && y == this.previousCloudGreen && z == this.previousCloudBlue;
    }

    private void buildCloudGeometry(VertexConsumer consumer, double x, double y, double z, float cloudRed, float cloudGreen, float cloudBlue) {
        float uOffset = (float)MathHelper.floor((double)x) * 0.00390625f;
        float vOffset = (float)MathHelper.floor((double)z) * 0.00390625f;
        float cloudXRed = cloudRed * 0.9f;
        float cloudXGreen = cloudGreen * 0.9f;
        float cloudXBlue = cloudBlue * 0.9f;
        float cloudYRed = cloudRed * 0.7f;
        float cloudYGreen = cloudGreen * 0.7f;
        float cloudYBlue = cloudBlue * 0.7f;
        float cloudZRed = cloudRed * 0.8f;
        float cloudZGreen = cloudGreen * 0.8f;
        float cloudZBlue = cloudBlue * 0.8f;
        float cloudY = (float)MathHelper.floor((double)(y / 4.0)) * 4.0f;
        for (int cloudEdgeX = -3; cloudEdgeX <= 4; ++cloudEdgeX) {
            for (int cloudEdgeZ = -3; cloudEdgeZ <= 4; ++cloudEdgeZ) {
                int index;
                float xOffset = cloudEdgeX * 8;
                float yOffset = cloudEdgeZ * 8;
                if (cloudY > -5.0f) {
                    consumer.addVertex(xOffset, cloudY, yOffset + 8.0f).setUv(xOffset * 0.00390625f + uOffset, (yOffset + 8.0f) * 0.00390625f + vOffset).setColor(cloudYRed, cloudYGreen, cloudYBlue, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    consumer.addVertex(xOffset + 8.0f, cloudY, yOffset + 8.0f).setUv((xOffset + 8.0f) * 0.00390625f + uOffset, (yOffset + 8.0f) * 0.00390625f + vOffset).setColor(cloudYRed, cloudYGreen, cloudYBlue, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    consumer.addVertex(xOffset + 8.0f, cloudY, yOffset).setUv((xOffset + 8.0f) * 0.00390625f + uOffset, yOffset * 0.00390625f + vOffset).setColor(cloudYRed, cloudYGreen, cloudYBlue, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    consumer.addVertex(xOffset, cloudY, yOffset).setUv(xOffset * 0.00390625f + uOffset, yOffset * 0.00390625f + vOffset).setColor(cloudYRed, cloudYGreen, cloudYBlue, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                }
                if (cloudY <= 5.0f) {
                    consumer.addVertex(xOffset, cloudY + 4.0f - 9.765625E-4f, yOffset + 8.0f).setUv(xOffset * 0.00390625f + uOffset, (yOffset + 8.0f) * 0.00390625f + vOffset).setColor(cloudRed, cloudGreen, cloudBlue, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                    consumer.addVertex(xOffset + 8.0f, cloudY + 4.0f - 9.765625E-4f, yOffset + 8.0f).setUv((xOffset + 8.0f) * 0.00390625f + uOffset, (yOffset + 8.0f) * 0.00390625f + vOffset).setColor(cloudRed, cloudGreen, cloudBlue, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                    consumer.addVertex(xOffset + 8.0f, cloudY + 4.0f - 9.765625E-4f, yOffset).setUv((xOffset + 8.0f) * 0.00390625f + uOffset, yOffset * 0.00390625f + vOffset).setColor(cloudRed, cloudGreen, cloudBlue, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                    consumer.addVertex(xOffset, cloudY + 4.0f - 9.765625E-4f, yOffset).setUv(xOffset * 0.00390625f + uOffset, yOffset * 0.00390625f + vOffset).setColor(cloudRed, cloudGreen, cloudBlue, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                }
                if (cloudEdgeX > -1) {
                    for (index = 0; index < 8; ++index) {
                        consumer.addVertex(xOffset + (float)index + 0.0f, cloudY + 0.0f, yOffset + 8.0f).setUv((xOffset + (float)index + 0.5f) * 0.00390625f + uOffset, (yOffset + 8.0f) * 0.00390625f + vOffset).setColor(cloudXRed, cloudXGreen, cloudXBlue, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                        consumer.addVertex(xOffset + (float)index + 0.0f, cloudY + 4.0f, yOffset + 8.0f).setUv((xOffset + (float)index + 0.5f) * 0.00390625f + uOffset, (yOffset + 8.0f) * 0.00390625f + vOffset).setColor(cloudXRed, cloudXGreen, cloudXBlue, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                        consumer.addVertex(xOffset + (float)index + 0.0f, cloudY + 4.0f, yOffset).setUv((xOffset + (float)index + 0.5f) * 0.00390625f + uOffset, yOffset * 0.00390625f + vOffset).setColor(cloudXRed, cloudXGreen, cloudXBlue, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                        consumer.addVertex(xOffset + (float)index + 0.0f, cloudY + 0.0f, yOffset).setUv((xOffset + (float)index + 0.5f) * 0.00390625f + uOffset, yOffset * 0.00390625f + vOffset).setColor(cloudXRed, cloudXGreen, cloudXBlue, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                    }
                }
                if (cloudEdgeX <= 1) {
                    for (index = 0; index < 8; ++index) {
                        consumer.addVertex(xOffset + (float)index + 1.0f - 9.765625E-4f, cloudY + 0.0f, yOffset + 8.0f).setUv((xOffset + (float)index + 0.5f) * 0.00390625f + uOffset, (yOffset + 8.0f) * 0.00390625f + vOffset).setColor(cloudXRed, cloudXGreen, cloudXBlue, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                        consumer.addVertex(xOffset + (float)index + 1.0f - 9.765625E-4f, cloudY + 4.0f, yOffset + 8.0f).setUv((xOffset + (float)index + 0.5f) * 0.00390625f + uOffset, (yOffset + 8.0f) * 0.00390625f + vOffset).setColor(cloudXRed, cloudXGreen, cloudXBlue, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                        consumer.addVertex(xOffset + (float)index + 1.0f - 9.765625E-4f, cloudY + 4.0f, yOffset).setUv((xOffset + (float)index + 0.5f) * 0.00390625f + uOffset, yOffset * 0.00390625f + vOffset).setColor(cloudXRed, cloudXGreen, cloudXBlue, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                        consumer.addVertex(xOffset + (float)index + 1.0f - 9.765625E-4f, cloudY + 0.0f, yOffset).setUv((xOffset + (float)index + 0.5f) * 0.00390625f + uOffset, yOffset * 0.00390625f + vOffset).setColor(cloudXRed, cloudXGreen, cloudXBlue, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                    }
                }
                if (cloudEdgeZ > -1) {
                    for (int $$31 = 0; $$31 < 8; ++$$31) {
                        consumer.addVertex(xOffset, cloudY + 4.0f, yOffset + (float)$$31 + 0.0f).setUv(xOffset * 0.00390625f + uOffset, (yOffset + (float)$$31 + 0.5f) * 0.00390625f + vOffset).setColor(cloudZRed, cloudZGreen, cloudZBlue, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                        consumer.addVertex(xOffset + 8.0f, cloudY + 4.0f, yOffset + (float)$$31 + 0.0f).setUv((xOffset + 8.0f) * 0.00390625f + uOffset, (yOffset + (float)$$31 + 0.5f) * 0.00390625f + vOffset).setColor(cloudZRed, cloudZGreen, cloudZBlue, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                        consumer.addVertex(xOffset + 8.0f, cloudY + 0.0f, yOffset + (float)$$31 + 0.0f).setUv((xOffset + 8.0f) * 0.00390625f + uOffset, (yOffset + (float)$$31 + 0.5f) * 0.00390625f + vOffset).setColor(cloudZRed, cloudZGreen, cloudZBlue, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                        consumer.addVertex(xOffset, cloudY + 0.0f, yOffset + (float)$$31 + 0.0f).setUv(xOffset * 0.00390625f + uOffset, (yOffset + (float)$$31 + 0.5f) * 0.00390625f + vOffset).setColor(cloudZRed, cloudZGreen, cloudZBlue, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                    }
                }
                if (cloudEdgeZ > 1) continue;
                for (int $$32 = 0; $$32 < 8; ++$$32) {
                    consumer.addVertex(xOffset, cloudY + 4.0f, yOffset + (float)$$32 + 1.0f - 9.765625E-4f).setUv(xOffset * 0.00390625f + uOffset, (yOffset + (float)$$32 + 0.5f) * 0.00390625f + vOffset).setColor(cloudZRed, cloudZGreen, cloudZBlue, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                    consumer.addVertex(xOffset + 8.0f, cloudY + 4.0f, yOffset + (float)$$32 + 1.0f - 9.765625E-4f).setUv((xOffset + 8.0f) * 0.00390625f + uOffset, (yOffset + (float)$$32 + 0.5f) * 0.00390625f + vOffset).setColor(cloudZRed, cloudZGreen, cloudZBlue, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                    consumer.addVertex(xOffset + 8.0f, cloudY + 0.0f, yOffset + (float)$$32 + 1.0f - 9.765625E-4f).setUv((xOffset + 8.0f) * 0.00390625f + uOffset, (yOffset + (float)$$32 + 0.5f) * 0.00390625f + vOffset).setColor(cloudZRed, cloudZGreen, cloudZBlue, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                    consumer.addVertex(xOffset, cloudY + 0.0f, yOffset + (float)$$32 + 1.0f - 9.765625E-4f).setUv(xOffset * 0.00390625f + uOffset, (yOffset + (float)$$32 + 0.5f) * 0.00390625f + vOffset).setColor(cloudZRed, cloudZGreen, cloudZBlue, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                }
            }
        }
    }
}

