/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.core.world;

import net.labymod.addons.flux.core.Flux;
import net.labymod.addons.flux.core.configuration.FluxConfiguration;
import net.labymod.api.Laby;
import net.labymod.api.client.gfx.pipeline.RenderEnvironmentContext;
import net.labymod.api.configuration.loader.property.ConfigProperty;

public final class CullHelper {
    private static final FluxConfiguration CONFIGURATION = (FluxConfiguration)Flux.get().configuration();
    private static final ConfigProperty<Boolean> flux = CONFIGURATION.enabled();
    private static final ConfigProperty<Boolean> entityCulling = CONFIGURATION.entityCulling().enabled();
    private static final ConfigProperty<Boolean> cullEntities = CONFIGURATION.entityCulling().entities().enabled();
    private static final ConfigProperty<Boolean> cullBlockEntities = CONFIGURATION.entityCulling().blockEntities();
    private static final RenderEnvironmentContext environmentContext = Laby.references().renderEnvironmentContext();

    public static boolean isCulled(CullType type) {
        if (!((Boolean)flux.get()).booleanValue() || !((Boolean)entityCulling.get()).booleanValue() || environmentContext.isScreenContext()) {
            return false;
        }
        if (type == CullType.ENTITY) {
            return (Boolean)cullEntities.get();
        }
        if (type == CullType.BLOCK_ENTITY) {
            return (Boolean)cullBlockEntities.get();
        }
        return false;
    }

    public static enum CullType {
        BLOCK_ENTITY,
        ENTITY;

    }

    @FunctionalInterface
    public static interface CullFunction<T> {
        public boolean apply(T var1);
    }
}

