/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.core.world;

import net.labymod.addons.flux.core.Flux;
import net.labymod.addons.flux.core.configuration.FluxConfiguration;
import net.labymod.addons.flux.core.configuration.entityculling.interval.EntityCullingIntervalConfiguration;
import net.labymod.addons.flux.core.world.CullingTargetAccessor;
import net.labymod.addons.flux.core.world.FluxChunk;
import net.labymod.api.Laby;
import net.labymod.api.client.Minecraft;
import net.labymod.api.client.world.ClientWorld;
import net.labymod.api.client.world.MinecraftCamera;
import net.labymod.api.event.Phase;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.lifecycle.GameTickEvent;
import net.labymod.api.util.math.MathHelper;
import net.labymod.api.util.math.vector.DoubleVector3;
import net.labymod.api.util.time.TimeUtil;

public abstract class FluxClientWorld {
    private final Minecraft minecraft = Laby.labyAPI().minecraft();
    private final EntityCullingIntervalConfiguration interval = ((FluxConfiguration)Flux.get().configuration()).entityCulling().interval();
    private DoubleVector3 cameraPosition;
    private FluxChunk lastChunk = null;
    protected int lastBlockX;
    protected int lastBlockY;
    protected int lastBlockZ;
    protected boolean lastIsFullBlock;

    public FluxClientWorld() {
        Laby.labyAPI().eventBus().registerListener((Object)this);
    }

    @Subscribe
    public void onTick(GameTickEvent event) {
        if (event.phase() != Phase.POST) {
            return;
        }
        MinecraftCamera camera = this.minecraft.getCamera();
        if (camera != null) {
            this.cameraPosition = camera.position();
        }
    }

    public boolean isVisible(CullingTargetAccessor accessor) {
        long timePassedSinceLastCheck = TimeUtil.getCurrentTimeMillis() - accessor.getLastTimeChecked();
        if (accessor.isLastCullingVisible() && timePassedSinceLastCheck < 2000L || this.cameraPosition == null) {
            return true;
        }
        if (((Boolean)this.interval.enabled().get()).booleanValue()) {
            double distance = Math.max(Math.abs(accessor.getMinX() - this.cameraPosition.getX()), Math.max(Math.abs(accessor.getMinY() - this.cameraPosition.getY()), Math.abs(accessor.getMinZ() - this.cameraPosition.getZ())));
            distance = Math.max(0.0, distance - 5.0);
            int interval = (Integer)this.interval.updateInterval().get();
            long timeToCache = (long)((double)interval * distance);
            if (timePassedSinceLastCheck < timeToCache) {
                return accessor.isLastCullingVisible();
            }
        }
        boolean visible = this.isVisible(this.minecraft.clientWorld(), accessor.getMinX(), accessor.getMinY(), accessor.getMinZ(), accessor.getMaxX(), accessor.getMaxY(), accessor.getMaxZ(), this.cameraPosition.getX(), this.cameraPosition.getY(), this.cameraPosition.getZ());
        accessor.setLastCullingVisible(visible);
        return visible;
    }

    public boolean isVisible(ClientWorld world, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double cameraX, double cameraY, double cameraZ) {
        double distanceRay1X = minX - cameraX;
        double distanceRay1Y = minY - cameraY;
        double distanceRay1Z = minZ - cameraZ;
        double ray1X = cameraX;
        double ray1Y = cameraY;
        double ray1Z = cameraZ;
        double distanceRay1 = Math.sqrt(distanceRay1X * distanceRay1X + distanceRay1Y * distanceRay1Y + distanceRay1Z * distanceRay1Z);
        double step1X = distanceRay1X / distanceRay1;
        double step1Y = distanceRay1Y / distanceRay1;
        double step1Z = distanceRay1Z / distanceRay1;
        boolean ray1XPositive = step1X > 0.0;
        boolean ray1YPositive = step1Y > 0.0;
        boolean ray1ZPositive = step1Z > 0.0;
        double distanceRay2X = maxX - cameraX;
        double distanceRay2Y = maxY - cameraY;
        double distanceRay2Z = maxZ - cameraZ;
        double ray2X = cameraX;
        double ray2Y = cameraY;
        double ray2Z = cameraZ;
        double distanceRay2 = Math.sqrt(distanceRay2X * distanceRay2X + distanceRay2Y * distanceRay2Y + distanceRay2Z * distanceRay2Z);
        double step2X = distanceRay2X / distanceRay2;
        double step2Y = distanceRay2Y / distanceRay2;
        double step2Z = distanceRay2Z / distanceRay2;
        boolean ray2XPositive = step2X > 0.0;
        boolean ray2YPositive = step2Y > 0.0;
        boolean ray2ZPositive = step2Z > 0.0;
        double distanceRay3X = minX - cameraX;
        double distanceRay3Y = maxY - cameraY;
        double distanceRay3Z = minZ - cameraZ;
        double ray3X = cameraX;
        double ray3Y = cameraY;
        double ray3Z = cameraZ;
        double distanceRay3 = Math.sqrt(distanceRay3X * distanceRay3X + distanceRay3Y * distanceRay3Y + distanceRay3Z * distanceRay3Z);
        double step3X = distanceRay3X / distanceRay3;
        double step3Y = distanceRay3Y / distanceRay3;
        double step3Z = distanceRay3Z / distanceRay3;
        boolean ray3XPositive = step3X > 0.0;
        boolean ray3YPositive = step3Y > 0.0;
        boolean ray3ZPositive = step3Z > 0.0;
        double distanceRay4X = maxX - cameraX;
        double distanceRay4Y = minY - cameraY;
        double distanceRay4Z = maxZ - cameraZ;
        double ray4X = cameraX;
        double ray4Y = cameraY;
        double ray4Z = cameraZ;
        double distanceRay4 = Math.sqrt(distanceRay4X * distanceRay4X + distanceRay4Y * distanceRay4Y + distanceRay4Z * distanceRay4Z);
        double step4X = distanceRay4X / distanceRay4;
        double step4Y = distanceRay4Y / distanceRay4;
        double step4Z = distanceRay4Z / distanceRay4;
        boolean ray4XPositive = step4X > 0.0;
        boolean ray4YPositive = step4Y > 0.0;
        boolean ray4ZPositive = step4Z > 0.0;
        double maxDistance = Math.max(Math.max(Math.abs(distanceRay1), Math.abs(distanceRay2)), Math.max(Math.abs(distanceRay3), Math.abs(distanceRay4)));
        boolean ray1Hit = false;
        boolean ray2Hit = false;
        boolean ray3Hit = false;
        boolean ray4Hit = false;
        boolean ray1Free = false;
        boolean ray2Free = false;
        boolean ray3Free = false;
        boolean ray4Free = false;
        int i = 0;
        while ((double)i < Math.ceil(maxDistance)) {
            if (this.isFullBlockAt(world, MathHelper.floor((double)ray1X), MathHelper.floor((double)ray1Y), MathHelper.floor((double)ray1Z))) {
                ray1Hit = ray1Free;
            } else {
                ray1Free = true;
            }
            if (this.isFullBlockAt(world, MathHelper.floor((double)ray2X), MathHelper.floor((double)ray2Y), MathHelper.floor((double)ray2Z))) {
                ray2Hit = ray2Free;
            } else {
                ray2Free = true;
            }
            if (this.isFullBlockAt(world, MathHelper.floor((double)ray3X), MathHelper.floor((double)ray3Y), MathHelper.floor((double)ray3Z))) {
                ray3Hit = ray3Free;
            } else {
                ray3Free = true;
            }
            if (this.isFullBlockAt(world, MathHelper.floor((double)ray4X), MathHelper.floor((double)ray4Y), MathHelper.floor((double)ray4Z))) {
                ray4Hit = ray4Free;
            } else {
                ray4Free = true;
            }
            if (ray1Hit && ray2Hit && ray3Hit && ray4Hit) {
                return false;
            }
            ray1X = ray1XPositive ? Math.min(ray1X + step1X, minX) : Math.max(ray1X + step1X, minX);
            ray1Y = ray1YPositive ? Math.min(ray1Y + step1Y, minY) : Math.max(ray1Y + step1Y, minY);
            ray1Z = ray1ZPositive ? Math.min(ray1Z + step1Z, minZ) : Math.max(ray1Z + step1Z, minZ);
            ray2X = ray2XPositive ? Math.min(ray2X + step2X, maxX) : Math.max(ray2X + step2X, maxX);
            ray2Y = ray2YPositive ? Math.min(ray2Y + step2Y, maxY) : Math.max(ray2Y + step2Y, maxY);
            ray2Z = ray2ZPositive ? Math.min(ray2Z + step2Z, maxZ) : Math.max(ray2Z + step2Z, maxZ);
            ray3X = ray3XPositive ? Math.min(ray3X + step3X, minX) : Math.max(ray3X + step3X, minX);
            ray3Y = ray3YPositive ? Math.min(ray3Y + step3Y, maxY) : Math.max(ray3Y + step3Y, minY);
            ray3Z = ray3ZPositive ? Math.min(ray3Z + step3Z, minZ) : Math.max(ray3Z + step3Z, minZ);
            ray4X = ray4XPositive ? Math.min(ray4X + step4X, maxX) : Math.max(ray4X + step4X, maxX);
            ray4Y = ray4YPositive ? Math.min(ray4Y + step4Y, minY) : Math.max(ray4Y + step4Y, minY);
            ray4Z = ray4ZPositive ? Math.min(ray4Z + step4Z, maxZ) : Math.max(ray4Z + step4Z, maxZ);
            ++i;
        }
        return true;
    }

    public boolean isFullBlockAt(ClientWorld world, int x, int y, int z) {
        FluxChunk chunk;
        if (this.isLastBlock(x, y, z)) {
            return this.lastIsFullBlock;
        }
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        if (this.lastChunk == null || this.lastChunk.getChunkX() != chunkX || this.lastChunk.getChunkZ() != chunkZ) {
            this.lastChunk = chunk = (FluxChunk)world.getChunk(chunkX, chunkZ);
        } else {
            chunk = this.lastChunk;
        }
        this.lastBlockX = x;
        this.lastBlockY = y;
        this.lastBlockZ = z;
        this.lastIsFullBlock = chunk.isFullBlockAt(x, y, z);
        return this.lastIsFullBlock;
    }

    protected boolean isLastBlock(int x, int y, int z) {
        return this.lastBlockX == x && this.lastBlockY == y && this.lastBlockZ == z;
    }
}

