/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.core.world;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.labymod.api.util.logging.Logging;

public class IdToObjectMap<V> {
    private static final Logging LOGGER = Logging.create(IdToObjectMap.class);
    private final Long2ObjectMap<V> map;

    public IdToObjectMap() {
        this((Long2ObjectMap<V>)new Long2ObjectOpenHashMap());
    }

    public IdToObjectMap(Long2ObjectMap<V> map) {
        this.map = map;
    }

    public boolean containsKey(long key) {
        return this.map.containsKey(key);
    }

    public void put(long key, V valve) {
        this.map.put(key, valve);
    }

    public V remove(long key) {
        return (V)this.map.remove(key);
    }

    public V get(long key) {
        try {
            return (V)this.map.get(key);
        }
        catch (Throwable throwable) {
            LOGGER.error((CharSequence)"Unexpected error", throwable);
            return null;
        }
    }

    public V getOrDefault(long key, V defaultValue) {
        try {
            Object result = this.map.getOrDefault(key, defaultValue);
            return (V)(result == null ? defaultValue : result);
        }
        catch (Throwable throwable) {
            LOGGER.error((CharSequence)"Unexpected error", throwable);
            return defaultValue;
        }
    }

    public int size() {
        return this.map.size();
    }
}

