/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.v1_17_1.util;

import net.labymod.addons.flux.core.util.NormalPacker;
import net.labymod.api.util.math.MathHelper;

public final class MatrixHelper {
    public static int packedNormal(c matrix, k normal) {
        return MatrixHelper.packedNormal(matrix, normal.a(), normal.b(), normal.c());
    }

    public static int packedNormal(c matrix, float x, float y2, float z) {
        float normX = MatrixHelper.transformX(matrix, x, y2, z);
        float normY = MatrixHelper.transformY(matrix, x, y2, z);
        float normZ = MatrixHelper.transformZ(matrix, x, y2, z);
        return NormalPacker.pack(normX, normY, normZ);
    }

    public static float transformX(c matrix, float x, float y2, float z) {
        return MathHelper.fma((float)matrix.a, (float)x, (float)MathHelper.fma((float)matrix.b, (float)y2, (float)(matrix.c * z)));
    }

    public static float transformY(c matrix, float x, float y2, float z) {
        return MathHelper.fma((float)matrix.d, (float)x, (float)MathHelper.fma((float)matrix.e, (float)y2, (float)(matrix.f * z)));
    }

    public static float transformZ(c matrix, float x, float y2, float z) {
        return MathHelper.fma((float)matrix.g, (float)x, (float)MathHelper.fma((float)matrix.h, (float)y2, (float)(matrix.i * z)));
    }

    public static float transformX(d matrix, float x, float y2, float z) {
        return MathHelper.fma((float)matrix.a, (float)x, (float)MathHelper.fma((float)matrix.b, (float)y2, (float)MathHelper.fma((float)matrix.c, (float)z, (float)matrix.d)));
    }

    public static float transformY(d matrix, float x, float y2, float z) {
        return MathHelper.fma((float)matrix.e, (float)x, (float)MathHelper.fma((float)matrix.f, (float)y2, (float)MathHelper.fma((float)matrix.g, (float)z, (float)matrix.h)));
    }

    public static float transformZ(d matrix, float x, float y2, float z) {
        return MathHelper.fma((float)matrix.i, (float)x, (float)MathHelper.fma((float)matrix.j, (float)y2, (float)MathHelper.fma((float)matrix.k, (float)z, (float)matrix.l)));
    }
}

