/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.v1_17_1.util;

import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;

public final class QuadSorter {
    @NotNull
    public static k[] calculateQuadSortingPoints(int stride, int primitiveStride, int count, ByteBuffer buffer, int offset) {
        k[] points = new k[count];
        long ptr = MemoryUtil.memAddress((ByteBuffer)buffer, (int)offset);
        for (int index = 0; index < count; ++index) {
            long ptr0 = ptr + (long)index * (long)primitiveStride * (long)stride;
            long ptr1 = ptr + ((long)index * (long)primitiveStride + 2L) * (long)stride;
            float x0 = MemoryUtil.memGetFloat((long)ptr0);
            float y0 = MemoryUtil.memGetFloat((long)(ptr0 + 4L));
            float z0 = MemoryUtil.memGetFloat((long)(ptr0 + 8L));
            float x1 = MemoryUtil.memGetFloat((long)ptr1);
            float y1 = MemoryUtil.memGetFloat((long)(ptr1 + 4L));
            float z1 = MemoryUtil.memGetFloat((long)(ptr1 + 8L));
            points[index] = new k((x0 + x1) * 0.5f, (y0 + y1) * 0.5f, (z0 + z1) * 0.5f);
        }
        return points;
    }
}

