/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.v1_19_4.util;

import org.lwjgl.system.MemoryUtil;

public final class IndexBufferWriter {
    private static final int[] VERTEX_ORDER = new int[]{0, 1, 2, 2, 3, 0};
    private static final int BYTE_SIZE = 1;
    private static final int SHORT_SIZE = 2;
    private static final int INT_SIZE = 4;

    public static void write(ehj.a indexType, long ptr, int primitiveStride, int[] indices) {
        switch (indexType) {
            case a: {
                for (int index : indices) {
                    int start = index * primitiveStride;
                    for (int offset : VERTEX_ORDER) {
                        MemoryUtil.memPutByte((long)ptr, (byte)((byte)(start + offset)));
                        ++ptr;
                    }
                }
                break;
            }
            case b: {
                for (int index : indices) {
                    int start = index * primitiveStride;
                    for (int offset : VERTEX_ORDER) {
                        MemoryUtil.memPutShort((long)ptr, (short)((short)(start + offset)));
                        ptr += 2L;
                    }
                }
                break;
            }
            case c: {
                for (int index : indices) {
                    int start = index * primitiveStride;
                    for (int offset : VERTEX_ORDER) {
                        MemoryUtil.memPutInt((long)ptr, (int)(start + offset));
                        ptr += 4L;
                    }
                }
                break;
            }
        }
    }
}

