/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.v1_20_5.mixins.batching;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.labymod.addons.flux.core.util.Identifiable;
import org.jetbrains.annotations.UnknownNullability;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={dwf.class})
public class MixinEntityLookup<T extends dwd> {
    private final Int2ObjectMap<List<T>> flux$entities = new Int2ObjectOpenHashMap();
    private final List<T> flux$bakedEntities = new ArrayList<T>();

    @Inject(method={"getAllEntities"}, at={@At(value="HEAD")}, cancellable=true)
    private void flux$getAllSortedEntities(CallbackInfoReturnable<Iterable<T>> cir) {
        cir.setReturnValue(this.flux$bakedEntities);
    }

    @Inject(method={"add"}, at={@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;put(ILjava/lang/Object;)Ljava/lang/Object;", shift=At.Shift.AFTER)})
    private void flux$addEntity(T entityAccess, CallbackInfo ci) {
        List<T> list = this.flux$findList(entityAccess, true);
        list.add(entityAccess);
        this.flux$sortEntities();
    }

    @Inject(method={"remove"}, at={@At(value="TAIL")})
    private void flux$removeEntity(T entity, CallbackInfo ci) {
        List<T> list = this.flux$findList(entity, false);
        if (list == null) {
            return;
        }
        list.remove(entity);
        this.flux$sortEntities();
    }

    private void flux$sortEntities() {
        this.flux$bakedEntities.clear();
        for (List value : this.flux$entities.values()) {
            this.flux$bakedEntities.addAll(value);
        }
    }

    private @UnknownNullability List<T> flux$findList(T entityAccess, boolean insert) {
        if (!(entityAccess instanceof bsv)) {
            throw new IllegalArgumentException();
        }
        bsv entity = (bsv)entityAccess;
        btb type = entity.ak();
        int id = -1;
        if (type instanceof Identifiable) {
            Identifiable identifiable = (Identifiable)type;
            id = identifiable.getId();
        }
        ArrayList list = (ArrayList)this.flux$entities.get(id);
        if (insert && list == null) {
            list = new ArrayList(32);
            this.flux$entities.put(id, list);
        }
        return list;
    }
}

