/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addons.flux.v1_21_1.util;

import net.labymod.addons.flux.core.util.NormalPacker;
import net.labymod.api.util.math.MathHelper;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public final class MatrixHelper {
    public static int packedNormal(Matrix3f matrix, Vector3f normal) {
        return MatrixHelper.packedNormal(matrix, normal.x, normal.y, normal.z);
    }

    public static int packedNormal(Matrix3f matrix, float x, float y, float z) {
        float normX = MatrixHelper.transformX(matrix, x, y, z);
        float normY = MatrixHelper.transformY(matrix, x, y, z);
        float normZ = MatrixHelper.transformZ(matrix, x, y, z);
        return NormalPacker.pack(normX, normY, normZ);
    }

    public static float transformX(Matrix3f matrix, float x, float y, float z) {
        return MathHelper.fma((float)matrix.m00(), (float)x, (float)MathHelper.fma((float)matrix.m10(), (float)y, (float)(matrix.m20() * z)));
    }

    public static float transformY(Matrix3f matrix, float x, float y, float z) {
        return MathHelper.fma((float)matrix.m01(), (float)x, (float)MathHelper.fma((float)matrix.m11(), (float)y, (float)(matrix.m21() * z)));
    }

    public static float transformZ(Matrix3f matrix, float x, float y, float z) {
        return MathHelper.fma((float)matrix.m02(), (float)x, (float)MathHelper.fma((float)matrix.m12(), (float)y, (float)(matrix.m22() * z)));
    }

    public static float transformX(Matrix4f matrix, float x, float y, float z) {
        return MathHelper.fma((float)matrix.m00(), (float)x, (float)MathHelper.fma((float)matrix.m10(), (float)y, (float)MathHelper.fma((float)matrix.m20(), (float)z, (float)matrix.m30())));
    }

    public static float transformY(Matrix4f matrix, float x, float y, float z) {
        return MathHelper.fma((float)matrix.m01(), (float)x, (float)MathHelper.fma((float)matrix.m11(), (float)y, (float)MathHelper.fma((float)matrix.m21(), (float)z, (float)matrix.m31())));
    }

    public static float transformZ(Matrix4f matrix, float x, float y, float z) {
        return MathHelper.fma((float)matrix.m02(), (float)x, (float)MathHelper.fma((float)matrix.m12(), (float)y, (float)MathHelper.fma((float)matrix.m22(), (float)z, (float)matrix.m32())));
    }
}

