#version 150

#l3d_import <labymod:shaders/include/globals.glsl>
#l3d_import <labymod:shaders/include/dynamic_transforms.glsl>

uniform sampler2D DiffuseSampler;

in vec2 texCoord;
in vec4 vertexColor;
in float vertexDistance;

out vec4 fragColor;

void main() {
  vec4 imageColor = TEXTURE(DiffuseSampler, texCoord);
  vec4 finalColor = imageColor * vertexColor;

  if (finalColor.a < 0.1) {
    discard;
  }

  fragColor = finalColor;
}