#version 150

#l3d_import <labymod:shaders/include/projection.glsl>
#l3d_import <labymod:shaders/include/globals.glsl>
#l3d_import <labymod:shaders/include/dynamic_transforms.glsl>

in vec3 Position;
in vec2 UV;
in vec4 Color;
in vec3 Normal;

out vec2 texCoord;
out vec4 vertexColor;

out float vertexDistance;

void main() {
  gl_Position = DEFAULT_TRANSFORM(ProjectionMatrix, ModelViewMatrix, vec4(Position, 1.0));

  texCoord = UV;

  vertexColor = Color;
  vertexDistance = length((ModelViewMatrix * vec4(Position, 1.0)).xyz);
}