#version 150

uniform sampler2D DiffuseSampler;
uniform vec4 ColorModulator;

in vec2 texCoord;
in vec4 vertexColor;

out vec4 fragColor;

void main() {
    vec4 color = TEXTURE(DiffuseSampler, texCoord);

    //#if TRANSULENT_ENTITY
    if (color.a < 0.1) {
        discard;
    }
    //#endif

    fragColor = color * vertexColor * ColorModulator;
}
