#version 150

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV1;
in ivec2 UV2;
in vec3 Normal;

uniform mat4 ProjectionMatrix;
uniform mat4 ModelViewMatrix;

uniform sampler2D LightSampler;

uniform ivec2 LightCoords;
uniform vec3 LightDirection0;
uniform vec3 LightDirection1;

out vec2 texCoord;
out vec4 vertexColor;

void main() {
    vec4 position = DEFAULT_TRANSFORM(ProjectionMatrix, ModelViewMatrix, vec4(Position, 1.0));

    vec3 normal = DEFAULT_TRANSFORM(ProjectionMatrix, ModelViewMatrix, vec4(Normal, 0.0)).xyz;

    vertexColor = LIGHT_COLOR(LightDirection0, LightDirection1, Normal, Color, 0.6, 0.4) * TEXEL_FETCH(LightSampler, LightCoords, 16);

    texCoord = UV0;

    gl_Position = position;
}