/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.api;

import java.util.ArrayList;
import java.util.Collections;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;
import net.labymod.api.util.Color;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.include.com.google.common.collect.BiMap;
import org.spongepowered.include.com.google.common.collect.HashBiMap;

public class GlobalTagDeserializer {
    private static final char RESET_CHAR = 'r';
    private static final GlobalTagDeserializer INSTANCE = new GlobalTagDeserializer();
    private static final BiMap<TextColor, Character> TEXT_COLOR_CHARS = HashBiMap.create((int)16);
    private static final BiMap<TextDecoration, Character> DECORATION_CHARS = HashBiMap.create((int)5);
    private final char character = (char)38;

    private GlobalTagDeserializer() {
    }

    public static Component deserialize(String input) {
        return INSTANCE.deserializeString(input);
    }

    public Component deserializeString(@Nullable String input) {
        String remaining;
        if (input == null) {
            return Component.empty();
        }
        int nextSection = this.nextColor(input, input.length() - 1);
        if (nextSection == -1) {
            return Component.text((String)input);
        }
        boolean reset = false;
        int pos = input.length();
        TextComponent.Builder current = null;
        ArrayList<TextComponent> parts = new ArrayList<TextComponent>();
        do {
            int from;
            char format;
            TextColor textColor = null;
            TextDecoration decoration = null;
            char formatIndicator = input.charAt(nextSection);
            if (formatIndicator == this.character) {
                format = input.charAt(nextSection + 1);
                from = nextSection + 2;
            } else if (formatIndicator == '#') {
                format = formatIndicator;
                int nextHexEnd = input.indexOf(62, nextSection);
                if (nextHexEnd != -1) {
                    int value;
                    String hex = input.substring(nextSection, nextHexEnd);
                    try {
                        value = Integer.parseInt(hex.substring(1), 16);
                    }
                    catch (IllegalArgumentException ignored) {
                        value = Color.WHITE.getValue();
                    }
                    textColor = TextColor.color((int)value);
                    from = nextHexEnd + 1;
                } else {
                    from = nextSection;
                }
            } else {
                format = 'r';
                from = nextSection;
            }
            if (format != 'r' && format != '#' && (textColor = (TextColor)TEXT_COLOR_CHARS.inverse().get((Object)Character.valueOf(format))) == null) {
                decoration = (TextDecoration)DECORATION_CHARS.inverse().get((Object)Character.valueOf(format));
            }
            if (format != 'r' && textColor == null && decoration == null) continue;
            if (from != pos) {
                if (current != null) {
                    if (reset) {
                        parts.add(current.build());
                        reset = false;
                        current = Component.text();
                    } else {
                        current = (TextComponent.Builder)Component.text().append((Component)current.build());
                    }
                } else {
                    current = Component.text();
                }
                current.text(input.substring(from, pos));
            } else if (current == null) {
                current = Component.text();
            }
            if (!reset) {
                if (format == 'r') {
                    reset = true;
                } else if (textColor != null) {
                    current.color(textColor);
                    reset = true;
                } else {
                    current.decorate(decoration);
                }
            }
            int n = pos = formatIndicator == '#' ? nextSection - 1 : nextSection;
        } while ((nextSection = this.nextColor(input, nextSection - 1)) != -1);
        if (current != null) {
            parts.add(current.build());
        }
        String string = remaining = pos > 0 ? input.substring(0, pos) : "";
        if (parts.size() == 1 && remaining.isEmpty()) {
            return (Component)parts.getFirst();
        }
        Collections.reverse(parts);
        return ((TextComponent.Builder)Component.text().text(remaining).append(parts)).build();
    }

    private int nextColor(String input, int fromIndex) {
        int nextHexEnd;
        if (fromIndex < 0) {
            return -1;
        }
        int nextSection = input.lastIndexOf(this.character, fromIndex);
        if (nextSection > input.length() - 2) {
            nextSection = -1;
        }
        if ((nextHexEnd = input.lastIndexOf(62, fromIndex)) == -1) {
            return nextSection;
        }
        int nextHexStart = input.lastIndexOf("<#", nextHexEnd);
        if (nextHexStart == -1) {
            return nextSection;
        }
        if (nextHexStart > nextSection) {
            return nextHexStart + 1;
        }
        return nextSection;
    }

    static {
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.BLACK, (Object)Character.valueOf('0'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.DARK_BLUE, (Object)Character.valueOf('1'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.DARK_GREEN, (Object)Character.valueOf('2'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.DARK_AQUA, (Object)Character.valueOf('3'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.DARK_RED, (Object)Character.valueOf('4'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.DARK_PURPLE, (Object)Character.valueOf('5'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.GOLD, (Object)Character.valueOf('6'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.GRAY, (Object)Character.valueOf('7'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.DARK_GRAY, (Object)Character.valueOf('8'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.BLUE, (Object)Character.valueOf('9'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.GREEN, (Object)Character.valueOf('a'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.AQUA, (Object)Character.valueOf('b'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.RED, (Object)Character.valueOf('c'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.LIGHT_PURPLE, (Object)Character.valueOf('d'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.YELLOW, (Object)Character.valueOf('e'));
        TEXT_COLOR_CHARS.put((Object)NamedTextColor.WHITE, (Object)Character.valueOf('f'));
        DECORATION_CHARS.put((Object)TextDecoration.BOLD, (Object)Character.valueOf('l'));
        DECORATION_CHARS.put((Object)TextDecoration.ITALIC, (Object)Character.valueOf('o'));
        DECORATION_CHARS.put((Object)TextDecoration.UNDERLINED, (Object)Character.valueOf('n'));
        DECORATION_CHARS.put((Object)TextDecoration.STRIKETHROUGH, (Object)Character.valueOf('m'));
        DECORATION_CHARS.put((Object)TextDecoration.OBFUSCATED, (Object)Character.valueOf('k'));
    }
}

