/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.command;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.core.command.subcommands.ClearCacheCommand;
import com.rappytv.globaltags.core.command.subcommands.LinkSubcommand;
import com.rappytv.globaltags.core.command.subcommands.RedeemCommand;
import com.rappytv.globaltags.core.command.subcommands.RenewCacheCommand;
import com.rappytv.globaltags.core.command.subcommands.UnlinkSubcommand;
import com.rappytv.globaltags.core.command.subcommands.VerifyCommand;
import com.rappytv.globaltags.wrapper.model.ApiInfo;
import net.labymod.api.client.chat.command.Command;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;

public class GlobalTagCommand
extends Command {
    private final GlobalTagAPI api = GlobalTagsAddon.getAPI();
    private final String version;

    public GlobalTagCommand(GlobalTagsAddon addon) {
        super("globaltags", new String[]{"globaltag", "gt"});
        this.version = addon.addonInfo().getVersion();
        this.translationKey("globaltags.commands.base");
        this.withSubCommand(new ClearCacheCommand(this.api));
        this.withSubCommand(new LinkSubcommand(this.api));
        this.withSubCommand(new RedeemCommand(this.api));
        this.withSubCommand(new RenewCacheCommand(this.api));
        this.withSubCommand(new UnlinkSubcommand(this.api));
        this.withSubCommand(new VerifyCommand(this.api));
    }

    public boolean execute(String prefix, String[] arguments) {
        this.api.getApiHandler().getApiInfo(response -> {
            TextComponent clearComponent = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().append(GlobalTagsAddon.prefix())).append((Component)Component.translatable((String)this.getTranslationKey("version"), (TextColor)NamedTextColor.GREEN, (Component[])new Component[]{Component.text((String)this.version, (TextColor)NamedTextColor.AQUA)}))).append((Component)Component.newline())).append(GlobalTagsAddon.prefix())).append((Component)Component.translatable((String)this.getTranslationKey("api.version"), (TextColor)NamedTextColor.GREEN, (Component[])new Component[]{response != null && response.isSuccessful() ? Component.text((String)((ApiInfo)response.getData()).getVersion(), (TextColor)NamedTextColor.AQUA) : Component.translatable((String)this.getTranslationKey("api.offline"), (TextColor)NamedTextColor.RED)}))).append((Component)Component.newline())).append(GlobalTagsAddon.prefix())).append(((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)Component.translatable((String)this.getTranslationKey("clearCache.label"), (Component[])new Component[0]).color(NamedTextColor.LIGHT_PURPLE)).decorate(TextDecoration.UNDERLINED)).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)this.getTranslationKey("clearCache.hover"), (TextColor)NamedTextColor.AQUA)))).clickEvent(ClickEvent.suggestCommand((String)("/" + prefix + " cc"))))).build();
            this.displayMessage((Component)clearComponent);
        });
        return true;
    }
}

