/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.command.subcommands;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import net.labymod.api.Laby;
import net.labymod.api.client.chat.command.SubCommand;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;

public class LinkSubcommand
extends SubCommand {
    private final GlobalTagAPI api;

    public LinkSubcommand(GlobalTagAPI api) {
        super("link", new String[0]);
        this.api = api;
    }

    public boolean execute(String prefix, String[] arguments) {
        switch (arguments.length > 0 ? arguments[0].toLowerCase() : "none") {
            case "discord": {
                this.api.getApiHandler().linkDiscord(info -> {
                    if (info.isSuccessful()) {
                        String code = (String)info.getData();
                        Laby.references().chatExecutor().copyToClipboard(code);
                        this.displayMessage(GlobalTagsAddon.prefix().append((Component)Component.translatable((String)"globaltags.commands.link.discord.copied", (TextColor)NamedTextColor.GREEN)));
                    } else {
                        this.displayMessage(GlobalTagsAddon.prefix().append((Component)Component.text((String)info.getError(), (TextColor)NamedTextColor.RED)));
                    }
                });
                break;
            }
            case "email": {
                if (arguments.length < 2) {
                    this.displayMessage(((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append((Component)Component.translatable((String)"globaltags.commands.usage", (TextColor)NamedTextColor.RED, (Component[])new Component[]{Component.text((String)"/gt link email <address>")})));
                    return true;
                }
                this.api.getApiHandler().linkEmail(arguments[1], info -> {
                    if (info.isSuccessful()) {
                        this.displayMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append((Component)Component.text((String)((String)info.getData()), (TextColor)NamedTextColor.GREEN))).append((Component)Component.newline())).append(GlobalTagsAddon.prefix())).append(((TranslatableComponent)((TranslatableComponent)Component.translatable((String)"globaltags.commands.link.email.verify", (TextColor)NamedTextColor.AQUA).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.suggestCommand((String)"/gt verify email "))).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"globaltags.commands.link.email.hover", (Component[])new Component[0])))));
                    } else {
                        this.displayMessage(((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append((Component)Component.text((String)info.getError(), (TextColor)NamedTextColor.RED)));
                    }
                });
                break;
            }
            default: {
                this.displayMessage(((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append((Component)Component.translatable((String)"globaltags.commands.usage", (TextColor)NamedTextColor.RED, (Component[])new Component[]{Component.text((String)"/gt link <discord/email>")})));
            }
        }
        return true;
    }
}

