/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.interaction;

import com.rappytv.globaltags.api.Textures;
import com.rappytv.globaltags.api.Util;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.core.config.GlobalTagsConfig;
import com.rappytv.globaltags.core.ui.activities.interaction.BanActivity;
import com.rappytv.globaltags.wrapper.enums.GlobalPermission;
import com.rappytv.globaltags.wrapper.http.ApiResponse;
import com.rappytv.globaltags.wrapper.model.PlayerInfo;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.interaction.BulletPoint;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.resources.ResourceLocation;

public class ToggleBanBulletPoint
implements BulletPoint {
    private final GlobalTagsConfig config;
    private PlayerInfo<Component> target;

    public ToggleBanBulletPoint(GlobalTagsAddon addon) {
        this.config = (GlobalTagsConfig)addon.configuration();
    }

    public Component getTitle() {
        return Component.translatable((String)("globaltags.context." + (this.target.isBanned() ? "unban" : "ban") + ".name"), (Component[])new Component[0]);
    }

    public Icon getIcon() {
        return Icon.texture((ResourceLocation)Textures.ICON_ROUND);
    }

    public void execute(Player player) {
        if (this.target.isBanned()) {
            GlobalTagsAddon.getAPI().getApiHandler().unbanPlayer(this.target.getUUID(), response -> {
                if (response.isSuccessful()) {
                    Util.broadcastTagUpdate(this.target.getUUID());
                }
                Laby.references().chatExecutor().displayClientMessage(((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append(Util.getResponseComponent((ApiResponse<String>)response)));
            });
        } else {
            Laby.labyAPI().minecraft().executeNextTick(() -> Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)new BanActivity(player.getUniqueId(), player.getName())));
        }
    }

    public boolean isVisible(Player player) {
        if (!((Boolean)this.config.enabled().get()).booleanValue() || !((Boolean)this.config.showBulletPoints().get()).booleanValue()) {
            return false;
        }
        PlayerInfo executor = GlobalTagsAddon.getAPI().getCache().get(Laby.labyAPI().getUniqueId());
        this.target = GlobalTagsAddon.getAPI().getCache().get(player.getUniqueId());
        return executor != null && executor.hasPermission(GlobalPermission.MANAGE_BANS) && this.target != null;
    }
}

