/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.interaction;

import com.rappytv.globaltags.api.Textures;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.core.config.GlobalTagsConfig;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.interaction.BulletPoint;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.resources.ResourceLocation;

public class ToggleHideTagBulletPoint
implements BulletPoint {
    private final GlobalTagsConfig config;
    private UUID uuid;

    public ToggleHideTagBulletPoint(GlobalTagsAddon addon) {
        this.config = (GlobalTagsConfig)addon.configuration();
    }

    public Component getTitle() {
        return Component.translatable((String)("globaltags.context." + (this.config.hiddenTags().contains(this.uuid) ? "showTag" : "hideTag") + ".name"), (Component[])new Component[0]);
    }

    public Icon getIcon() {
        return Icon.texture((ResourceLocation)Textures.ICON_ROUND);
    }

    public void execute(Player player) {
        boolean hidden = this.config.hiddenTags().contains(this.uuid);
        if (hidden) {
            this.config.hiddenTags().remove(this.uuid);
        } else {
            this.config.hiddenTags().add(this.uuid);
        }
        Laby.references().chatExecutor().displayClientMessage(((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append((Component)Component.translatable((String)("globaltags.context." + (hidden ? "showTag" : "hideTag") + ".success"), (TextColor)NamedTextColor.GRAY, (Component[])new Component[]{Component.text((String)player.getName(), (TextColor)player.gameUser().displayColor())})));
    }

    public boolean isVisible(Player player) {
        if (!((Boolean)this.config.enabled().get()).booleanValue() || !((Boolean)this.config.showBulletPoints().get()).booleanValue()) {
            return false;
        }
        this.uuid = player.getUniqueId();
        return GlobalTagsAddon.getAPI().getCache().get(player.getUniqueId()) != null;
    }
}

