/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.activities.config;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.core.ui.widgets.config.ReferralLeaderboardEntryWidget;
import com.rappytv.globaltags.wrapper.enums.ReferralLeaderboardType;
import com.rappytv.globaltags.wrapper.model.ReferralLeaderboardEntry;
import java.util.List;
import java.util.Map;
import net.labymod.api.Laby;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.util.ThreadSafe;

@Link(value="player-list.lss")
@AutoActivity
public class ReferralLeaderboardActivity
extends SimpleActivity {
    private static Map<ReferralLeaderboardType, List<ReferralLeaderboardEntry>> leaderboards = null;
    private final GlobalTagAPI api;
    private final VerticalListWidget<ReferralLeaderboardEntryWidget> entries = (VerticalListWidget)new VerticalListWidget().addId("player-entries");
    private final HorizontalListWidget buttonMenu;
    private ReferralLeaderboardType selectedLeaderboard = ReferralLeaderboardType.TOTAL;

    public ReferralLeaderboardActivity() {
        this.api = GlobalTagsAddon.getAPI();
        this.buttonMenu = (HorizontalListWidget)new HorizontalListWidget().addId("button-menu");
        ButtonWidget totalViewButton = ButtonWidget.i18n((String)"globaltags.settings.referralLeaderboards.activity.total");
        ButtonWidget currentMonthViewButton = ButtonWidget.i18n((String)"globaltags.settings.referralLeaderboards.activity.currentMonth");
        totalViewButton.setEnabled(this.selectedLeaderboard != ReferralLeaderboardType.TOTAL);
        totalViewButton.setPressable(() -> {
            this.selectedLeaderboard = ReferralLeaderboardType.TOTAL;
            totalViewButton.setEnabled(false);
            currentMonthViewButton.setEnabled(true);
            this.initializeWithInfo(true);
        });
        currentMonthViewButton.setEnabled(this.selectedLeaderboard != ReferralLeaderboardType.CURRENT_MONTH);
        currentMonthViewButton.setPressable(() -> {
            this.selectedLeaderboard = ReferralLeaderboardType.CURRENT_MONTH;
            totalViewButton.setEnabled(true);
            currentMonthViewButton.setEnabled(false);
            this.initializeWithInfo(true);
        });
        this.buttonMenu.addEntry((Widget)totalViewButton);
        this.buttonMenu.addEntry((Widget)currentMonthViewButton);
    }

    public static void setLeaderboards(Map<ReferralLeaderboardType, List<ReferralLeaderboardEntry>> leaderboards) {
        ReferralLeaderboardActivity.leaderboards = leaderboards;
    }

    private void initializeWithInfo() {
        if (ThreadSafe.isRenderThread()) {
            this.initializeWithInfo(false);
        } else {
            Laby.labyAPI().minecraft().executeOnRenderThread(() -> this.initializeWithInfo(true));
        }
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget container = (FlexibleContentWidget)new FlexibleContentWidget().addId("container");
        container.addContent((Widget)this.buttonMenu);
        ScrollWidget scroll = new ScrollWidget(this.entries);
        container.addContent((Widget)scroll);
        ((Document)this.document).addChild((Widget)container);
        if (leaderboards == null) {
            this.api.getApiHandler().getReferralLeaderboards(response -> {
                if (!response.isSuccessful()) {
                    Laby.labyAPI().minecraft().executeOnRenderThread(() -> container.addContentInitialized(ComponentWidget.text((String)response.getError(), (TextColor)NamedTextColor.RED).addId("error-component")));
                    scroll.setVisible(false);
                    return;
                }
                leaderboards = (Map)response.getData();
                this.initializeWithInfo();
            });
        } else {
            this.initializeWithInfo();
        }
    }

    private void initializeWithInfo(boolean initialized) {
        this.entries.getChildren().clear();
        if (leaderboards == null) {
            return;
        }
        for (ReferralLeaderboardEntry entry : leaderboards.get(this.selectedLeaderboard)) {
            if (initialized) {
                this.entries.addChildInitialized((Widget)new ReferralLeaderboardEntryWidget(entry));
                continue;
            }
            this.entries.addChild((Widget)new ReferralLeaderboardEntryWidget(entry));
        }
    }
}

