/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.activities.interaction;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.api.Util;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.wrapper.http.ApiResponse;
import com.rappytv.globaltags.wrapper.model.BanInfo;
import java.util.UUID;
import java.util.function.Consumer;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.CheckBoxWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;

@Link(value="input.lss")
@AutoActivity
public class EditBanActivity
extends SimpleActivity {
    private final GlobalTagAPI api = GlobalTagsAddon.getAPI();
    private final UUID uuid;
    private final String username;

    public EditBanActivity(UUID uuid, String username) {
        this.uuid = uuid;
        this.username = username;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        this.api.getCache().resolve(this.uuid, info -> {
            if (info == null || info.getBanInfo() == null) {
                Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)null);
                return;
            }
            BanInfo banInfo = info.getBanInfo();
            FlexibleContentWidget windowWidget = (FlexibleContentWidget)new FlexibleContentWidget().addId("window");
            HorizontalListWidget profileWrapper = (HorizontalListWidget)new HorizontalListWidget().addId("header");
            IconWidget headWidget = (IconWidget)new IconWidget(Icon.head((UUID)this.uuid)).addId("head");
            ComponentWidget titleWidget = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.context.editBan.title", (Object[])new Object[]{this.username}).addId("username");
            VerticalListWidget content = (VerticalListWidget)new VerticalListWidget().addId("content");
            ComponentWidget inputLabelWidget = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.context.reason").addId("label");
            TextFieldWidget inputWidget = (TextFieldWidget)new TextFieldWidget().placeholder((Component)Component.translatable((String)"globaltags.context.placeholder", (TextColor)NamedTextColor.DARK_GRAY)).addId("input");
            String reason = banInfo.getReason();
            inputWidget.setText(reason, true);
            HorizontalListWidget checkboxWrapper = (HorizontalListWidget)new HorizontalListWidget().addId("checkbox-wrapper");
            CheckBoxWidget checkBoxWidget = (CheckBoxWidget)new CheckBoxWidget().addId("check-box");
            checkBoxWidget.setState(banInfo.isAppealable() ? CheckBoxWidget.State.CHECKED : CheckBoxWidget.State.UNCHECKED);
            ComponentWidget boxLabelWidget = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.context.editBan.appealable").addId("checkbox-label");
            ButtonWidget sendButton = (ButtonWidget)new ButtonWidget().updateComponent((Component)Component.translatable((String)"globaltags.context.editBan.send", (TextColor)NamedTextColor.AQUA)).addId("send-button");
            sendButton.setEnabled(false);
            sendButton.setActionListener(() -> {
                Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)null);
                this.api.getApiHandler().editBan(this.uuid, reason, checkBoxWidget.state() == CheckBoxWidget.State.CHECKED, response -> Laby.references().chatExecutor().displayClientMessage(((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append(Util.getResponseComponent((ApiResponse<String>)response))));
            });
            Consumer<String> updateButton = text -> {
                boolean reasonNotEmpty = !text.isBlank();
                boolean updatedReason = !text.equals(banInfo.getReason());
                boolean updatedCheckbox = checkBoxWidget.state() == CheckBoxWidget.State.CHECKED != banInfo.isAppealable();
                sendButton.setEnabled(reasonNotEmpty && (updatedReason || updatedCheckbox));
            };
            inputWidget.updateListener(updateButton);
            checkBoxWidget.setActionListener(() -> updateButton.accept(inputWidget.getText()));
            profileWrapper.addEntry((Widget)headWidget);
            profileWrapper.addEntry((Widget)titleWidget);
            checkboxWrapper.addEntry((Widget)checkBoxWidget);
            checkboxWrapper.addEntry((Widget)boxLabelWidget);
            content.addChild((Widget)inputLabelWidget);
            content.addChild((Widget)inputWidget);
            content.addChild((Widget)checkboxWrapper);
            content.addChild((Widget)sendButton);
            windowWidget.addContent((Widget)profileWrapper);
            windowWidget.addContent((Widget)content);
            ((Document)this.document).addChild((Widget)windowWidget);
        });
    }
}

