/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.widgets.config;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.api.event.RefreshInfoEvent;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.core.config.subconfig.AccountConfig;
import com.rappytv.globaltags.core.ui.widgets.config.AppealPopup;
import com.rappytv.globaltags.core.ui.widgets.config.TagPreviewWidget;
import com.rappytv.globaltags.wrapper.enums.GlobalIcon;
import com.rappytv.globaltags.wrapper.enums.GlobalPosition;
import com.rappytv.globaltags.wrapper.model.PlayerInfo;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.SimpleDateFormat;
import java.util.function.Consumer;
import net.labymod.api.Laby;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.configuration.loader.Config;
import net.labymod.api.configuration.settings.Setting;
import net.labymod.api.configuration.settings.accessor.SettingAccessor;
import net.labymod.api.configuration.settings.annotation.SettingElement;
import net.labymod.api.configuration.settings.annotation.SettingFactory;
import net.labymod.api.configuration.settings.annotation.SettingWidget;
import net.labymod.api.configuration.settings.widget.WidgetFactory;
import net.labymod.api.event.Event;
import net.labymod.api.event.Subscribe;
import net.labymod.api.util.ThreadSafe;

@AutoWidget
@SettingWidget
@Link(value="account-info.lss")
public class AccountInfoWidget
extends HorizontalListWidget {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private final AccountConfig config;
    private boolean reset = true;

    private AccountInfoWidget(AccountConfig config) {
        this.config = config;
        Laby.labyAPI().eventBus().registerListener((Object)this);
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        GlobalTagAPI api = GlobalTagsAddon.getAPI();
        this.addEntry(ButtonWidget.icon((Icon)Textures.SpriteCommon.REFRESH, () -> Laby.fireEvent((Event)new RefreshInfoEvent(true))).addId("refresh-button"));
        api.getCache().resolveSelf(info -> {
            if (ThreadSafe.isRenderThread()) {
                this.initializeWithInfo((PlayerInfo<Component>)info, false);
            } else {
                Laby.labyAPI().minecraft().executeOnRenderThread(() -> this.initializeWithInfo((PlayerInfo<Component>)info, true));
            }
        });
    }

    private void initializeWithInfo(PlayerInfo<Component> info, boolean async) {
        GlobalTagAPI api = GlobalTagsAddon.getAPI();
        Consumer<Widget> addEntry = async ? arg_0 -> ((AccountInfoWidget)this).addEntryInitialized(arg_0) : arg_0 -> ((AccountInfoWidget)this).addEntry(arg_0);
        Component error = this.getError(info);
        if (error != null) {
            ComponentWidget errorComponent = (ComponentWidget)ComponentWidget.component((Component)error).addId(new String[]{"text", "error"});
            addEntry.accept((Widget)errorComponent);
        } else {
            boolean updated;
            if (this.reset) {
                this.config.tag().set((Object)info.getPlainTag());
                this.config.position().set((Object)info.getPosition());
                this.config.icon().set((Object)info.getGlobalIconType());
                this.config.hideRoleIcon().set((Object)info.isRoleIconHidden());
                this.reset = false;
            }
            String iconUrl = TagPreviewWidget.getIconUrl(info, (GlobalIcon)this.config.icon().get());
            addEntry.accept((Widget)new TagPreviewWidget((String)this.config.tag().get(), iconUrl != null ? Icon.url((String)iconUrl) : null, (Boolean)this.config.hideRoleIcon().get() != false ? null : (info.getRoleIcon() != null ? Icon.url((String)api.getUrls().getRoleIcon(info.getRoleIcon())) : null)));
            boolean bl = updated = !((String)this.config.tag().get()).equals(info.getPlainTag()) || !((GlobalPosition)this.config.position().get()).equals((Object)info.getPosition()) || !((GlobalIcon)this.config.icon().get()).equals((Object)info.getGlobalIconType()) || !((Boolean)this.config.hideRoleIcon().get()).equals(info.isRoleIconHidden());
            if (updated) {
                addEntry.accept((Widget)ComponentWidget.component((Component)Component.text((String)"*", (TextColor)NamedTextColor.DARK_GRAY).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"globaltags.settings.account.accountInfo.unsaved", (TextColor)NamedTextColor.GRAY)))));
            }
        }
        if (info != null && info.isBanned()) {
            ButtonWidget appealButton = (ButtonWidget)ButtonWidget.i18n((String)"globaltags.settings.account.accountInfo.appeal.name", () -> new AppealPopup(api).displayInOverlay()).addId("appeal-button");
            appealButton.setHoverComponent((Component)Component.translatable((String)"globaltags.settings.account.accountInfo.appeal.description", (TextColor)NamedTextColor.GOLD));
            appealButton.setEnabled(info.getBanInfo().isAppealable());
            addEntry.accept((Widget)appealButton);
        }
    }

    private Component getError(PlayerInfo<Component> info) {
        String session = GlobalTagsAddon.getAPI().getAuthorization();
        if (session == null) {
            return Component.translatable((String)"globaltags.settings.account.accountInfo.labyConnect", (Component[])new Component[0]);
        }
        if (info == null) {
            return Component.translatable((String)"globaltags.settings.account.accountInfo.noInfo", (Component[])new Component[0]);
        }
        if (info.isBanned()) {
            Component banInfo = Component.empty().append((Component)Component.translatable((String)"globaltags.settings.account.accountInfo.reason", (TextColor)NamedTextColor.RED, (Component[])new Component[]{Component.text((String)info.getBanInfo().getReason(), (TextColor)NamedTextColor.GRAY)}));
            if (info.getBanInfo().getExpiresAt() != null) {
                banInfo.append((Component)Component.newline()).append((Component)Component.translatable((String)"globaltags.settings.account.accountInfo.expires", (TextColor)NamedTextColor.RED, (Component[])new Component[]{Component.text((String)dateFormat.format(info.getBanInfo().getExpiresAt()), (TextColor)NamedTextColor.GRAY)}));
            }
            return ((TextComponent)((TextComponent)Component.empty().append((Component)Component.translatable((String)"globaltags.settings.account.accountInfo.banned", (Component[])new Component[0]))).append((Component)Component.space())).append(Component.text((String)"\u24d8").hoverEvent(HoverEvent.showText((Component)banInfo)));
        }
        return null;
    }

    @Subscribe
    public void onRefresh(RefreshInfoEvent event) {
        if (event.refetch()) {
            GlobalTagsAddon.getAPI().getCache().removeSelf();
            this.reset = true;
        }
        if (ThreadSafe.isRenderThread()) {
            this.reInitialize();
        } else {
            Laby.labyAPI().minecraft().executeOnRenderThread(() -> ((AccountInfoWidget)this).reInitialize());
        }
    }

    public void destroy() {
        super.destroy();
        Laby.labyAPI().eventBus().unregisterListener((Object)this);
    }

    @SettingFactory
    public static class Factory
    implements WidgetFactory<AccountInfoSetting, AccountInfoWidget> {
        public AccountInfoWidget[] create(Setting setting, AccountInfoSetting annotation, SettingAccessor accessor) {
            Config config = accessor.config();
            if (!(config instanceof AccountConfig)) {
                return new AccountInfoWidget[0];
            }
            AccountConfig config2 = (AccountConfig)config;
            return new AccountInfoWidget[]{new AccountInfoWidget(config2)};
        }

        public Class<?>[] types() {
            return new Class[0];
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    @SettingElement(extended=true)
    public static @interface AccountInfoSetting {
    }
}

