/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.widgets.config;

import com.rappytv.globaltags.core.config.GlobalTagsConfig;
import java.util.UUID;
import java.util.function.Consumer;
import net.labymod.api.Laby;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.util.ThreadSafe;

@AutoWidget
public class HiddenPlayerWidget
extends HorizontalListWidget {
    private final UUID uuid;
    private final GlobalTagsConfig config;
    private final Consumer<HiddenPlayerWidget> onDelete;

    public HiddenPlayerWidget(UUID uuid, GlobalTagsConfig config, Consumer<HiddenPlayerWidget> onDelete) {
        this.uuid = uuid;
        this.config = config;
        this.onDelete = onDelete;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        IconWidget headWidget = (IconWidget)new IconWidget(Icon.head((UUID)this.uuid)).addId("player-head");
        ComponentWidget usernameWidget = (ComponentWidget)ComponentWidget.component((Component)this.getUsernameComponent(true, null)).addId("username-component");
        ButtonWidget removeButton = (ButtonWidget)ButtonWidget.icon((Icon)Textures.SpriteCommon.X, () -> {
            this.config.hiddenTags().remove(this.uuid);
            this.onDelete.accept(this);
        }).addId("remove-button");
        removeButton.setHoverComponent((Component)Component.translatable((String)"globaltags.settings.hiddenTagList.remove", (TextColor)NamedTextColor.GREEN));
        this.addEntry((Widget)headWidget);
        this.addEntry((Widget)usernameWidget);
        this.addEntry((Widget)removeButton);
        Laby.references().labyNetController().loadNameByUniqueId(this.uuid, name -> {
            if (ThreadSafe.isRenderThread()) {
                usernameWidget.setComponent(this.getUsernameComponent(false, (String)name.getNullable()));
                usernameWidget.addId("loaded");
            } else {
                Laby.labyAPI().minecraft().executeOnRenderThread(() -> {
                    usernameWidget.setComponent(this.getUsernameComponent(false, (String)name.getNullable()));
                    usernameWidget.addId("loaded");
                });
            }
        });
    }

    private Component getUsernameComponent(boolean loading, String username) {
        Component component = Component.empty().clickEvent(ClickEvent.openUrl((String)("https://laby.net/@" + String.valueOf(this.uuid))));
        if (loading) {
            component.append((Component)Component.translatable((String)"globaltags.settings.referralLeaderboards.activity.loading", (TextColor)NamedTextColor.GRAY));
        } else if (username == null) {
            component.append((Component)Component.translatable((String)"globaltags.settings.referralLeaderboards.activity.open", (Component[])new Component[0]));
        } else {
            component.append((Component)Component.text((String)username));
        }
        return component;
    }
}

