/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.widgets.config;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.wrapper.enums.GlobalIcon;
import com.rappytv.globaltags.wrapper.model.PlayerInfo;
import java.util.Objects;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.util.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoWidget
@Link(value="preview.lss")
public class TagPreviewWidget
extends HorizontalListWidget {
    private final GlobalTagAPI api;
    private Component tag;
    private Icon globalIcon;
    private Icon roleIcon;
    private ComponentWidget tagWidget;
    private IconWidget globalIconWidget;
    private IconWidget roleIconWidget;

    public TagPreviewWidget(@NotNull String tag, @Nullable Icon globalIcon, @Nullable Icon roleIcon) {
        Objects.requireNonNull(tag);
        this.api = GlobalTagsAddon.getAPI();
        this.tag = !tag.isBlank() ? this.api.translateColorCodes(tag) : null;
        this.globalIcon = globalIcon;
        this.roleIcon = roleIcon;
    }

    public TagPreviewWidget(@Nullable Component tag, @Nullable Icon globalIcon, @Nullable Icon roleIcon) {
        this.api = GlobalTagsAddon.getAPI();
        this.tag = tag;
        this.globalIcon = globalIcon;
        this.roleIcon = roleIcon;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        this.tagWidget = (ComponentWidget)ComponentWidget.empty().addId("tag");
        this.globalIconWidget = (IconWidget)new IconWidget(null).addId("global-icon");
        this.roleIconWidget = (IconWidget)new IconWidget(null).addId("role-icon");
        this.updateTag(this.tag);
        this.updateGlobalIcon(this.globalIcon);
        this.updateRoleIcon(this.roleIcon);
        this.addEntry((Widget)this.globalIconWidget);
        this.addEntry((Widget)this.tagWidget);
        this.addEntry((Widget)this.roleIconWidget);
    }

    @Nullable
    public static String getIconUrl(@Nullable PlayerInfo<?> info, GlobalIcon icon) {
        GlobalTagAPI api = GlobalTagsAddon.getAPI();
        if (info != null && icon == GlobalIcon.CUSTOM && info.getCustomIconHash() != null) {
            return api.getUrls().getCustomIcon(api.getClientUUID(), info.getCustomIconHash());
        }
        if (icon != GlobalIcon.NONE && icon != GlobalIcon.CUSTOM) {
            return api.getUrls().getDefaultIcon(icon);
        }
        return null;
    }

    public void updateTag(@NotNull String tag) {
        Objects.requireNonNull(tag);
        this.updateTag(!tag.isBlank() ? this.api.translateColorCodes(tag) : null);
    }

    public void updateGlobalIcon(@Nullable Icon icon) {
        this.globalIcon = icon;
        this.globalIconWidget.setVisible(this.globalIcon != null);
        this.runThreadSafely(() -> this.globalIconWidget.icon().set((Object)this.globalIcon));
    }

    public void updateGlobalIcon(@Nullable GlobalIcon icon, @Nullable UUID uuid, @Nullable String hash) {
        this.globalIcon = icon == GlobalIcon.CUSTOM && uuid != null && hash != null ? Icon.url((String)this.api.getUrls().getCustomIcon(uuid, hash)) : (icon == null ? null : Icon.url((String)this.api.getUrls().getDefaultIcon(icon)));
        this.updateGlobalIcon(this.globalIcon);
    }

    public void updateRoleIcon(@Nullable Icon icon) {
        this.roleIcon = icon;
        this.roleIconWidget.setVisible(this.roleIcon != null);
        this.runThreadSafely(() -> this.roleIconWidget.icon().set((Object)this.roleIcon));
    }

    public void updateRoleIcon(@Nullable String role) {
        this.roleIcon = role != null ? Icon.url((String)this.api.getUrls().getRoleIcon(role)) : null;
        this.updateRoleIcon(this.roleIcon);
    }

    private void runThreadSafely(Runnable runnable) {
        if (ThreadSafe.isRenderThread()) {
            runnable.run();
        } else {
            Laby.labyAPI().minecraft().executeOnRenderThread(runnable);
        }
    }

    public void updateTag(@Nullable Component component) {
        this.tag = component != null ? component : Component.translatable((String)"globaltags.settings.account.accountInfo.empty", (TextColor)NamedTextColor.RED);
        this.runThreadSafely(() -> this.tagWidget.setComponent(this.tag));
    }
}

