/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.config.subconfig;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.api.Util;
import com.rappytv.globaltags.api.event.RefreshInfoEvent;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.core.ui.activities.config.IconSelectorActivity;
import com.rappytv.globaltags.core.ui.activities.config.TagEditorActivity;
import com.rappytv.globaltags.core.ui.widgets.config.AccountInfoWidget;
import com.rappytv.globaltags.wrapper.enums.GlobalIcon;
import com.rappytv.globaltags.wrapper.enums.GlobalPosition;
import com.rappytv.globaltags.wrapper.http.ApiResponse;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.activity.Activity;
import net.labymod.api.client.gui.screen.widget.widgets.activity.settings.ActivitySettingWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.DropdownWidget;
import net.labymod.api.configuration.loader.Config;
import net.labymod.api.configuration.loader.annotation.Exclude;
import net.labymod.api.configuration.loader.annotation.IntroducedIn;
import net.labymod.api.configuration.loader.annotation.SpriteSlot;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.configuration.settings.Setting;
import net.labymod.api.configuration.settings.annotation.SettingSection;
import net.labymod.api.event.Event;
import net.labymod.api.util.Debounce;
import net.labymod.api.util.MethodOrder;

public class AccountConfig
extends Config {
    private static final Component TICK = Component.text((String)"\u2714", (TextColor)NamedTextColor.GREEN);
    @Exclude
    private final ConfigProperty<String> tag = new ConfigProperty((Object)"");
    @Exclude
    private final ConfigProperty<GlobalIcon> icon = new ConfigProperty((Object)GlobalIcon.NONE);
    @IntroducedIn(namespace="globaltags", value="1.2.0")
    @SpriteSlot(size=32, x=2, y=1)
    @AccountInfoWidget.AccountInfoSetting
    private final ConfigProperty<Boolean> accountInfo = new ConfigProperty((Object)false);
    @SpriteSlot(x=2, y=1)
    @DropdownWidget.DropdownSetting
    private final ConfigProperty<GlobalPosition> position = new ConfigProperty((Object)GlobalPosition.ABOVE);
    @IntroducedIn(namespace="globaltags", value="1.4.1")
    @SpriteSlot(y=3)
    @SwitchWidget.SwitchSetting
    private final ConfigProperty<Boolean> hideRoleIcon = new ConfigProperty((Object)false);

    public AccountConfig() {
        Runnable runnable = () -> Debounce.of((String)"globaltags-config-update", (long)1000L, () -> Laby.fireEvent((Event)new RefreshInfoEvent()));
        this.tag.addChangeListener(runnable);
        this.position.addChangeListener(runnable);
        this.icon.addChangeListener(runnable);
        this.hideRoleIcon.addChangeListener(runnable);
    }

    @SettingSection(value="settings", center=true)
    @IntroducedIn(namespace="globaltags", value="1.4.1")
    @MethodOrder(after="accountInfo")
    @SpriteSlot(x=3, y=2)
    @ActivitySettingWidget.ActivitySetting
    public Activity tagEditor() {
        String session = GlobalTagsAddon.getAPI().getAuthorization();
        if (session == null) {
            return new TagEditorActivity();
        }
        return new TagEditorActivity(GlobalTagsAddon.getAPI().getCache().get(GlobalTagsAddon.getAPI().getClientUUID()), this);
    }

    @MethodOrder(after="position")
    @IntroducedIn(namespace="globaltags", value="1.4.3")
    @SpriteSlot(x=1, y=2)
    @ActivitySettingWidget.ActivitySetting
    public Activity iconSelector() {
        String session = GlobalTagsAddon.getAPI().getAuthorization();
        if (session == null) {
            return new IconSelectorActivity();
        }
        return new IconSelectorActivity(GlobalTagsAddon.getAPI().getCache().get(GlobalTagsAddon.getAPI().getClientUUID()), this);
    }

    @SettingSection(value="actions", center=true)
    @MethodOrder(after="hideRoleIcon")
    @SpriteSlot(x=3, y=1)
    @ButtonWidget.ButtonSetting
    public void updateSettings(Setting setting) {
        GlobalTagAPI api = GlobalTagsAddon.getAPI();
        api.getCache().resolveSelf(info -> {
            if (api.getAuthorization() == null) {
                Util.notify((Component)Component.translatable((String)"globaltags.general.error", (Component[])new Component[0]), (Component)Component.translatable((String)"globaltags.settings.account.accountInfo.labyConnect", (Component[])new Component[0]));
                return;
            }
            if (info == null || !info.getPlainTag().equals(this.tag.get())) {
                api.getApiHandler().setTag((String)this.tag.get(), response -> {
                    if (response.isSuccessful()) {
                        Util.update(api, Util.ResultType.TAG, TICK);
                    } else {
                        Util.update(api, Util.ResultType.TAG, (Component)Component.text((String)response.getError(), (TextColor)NamedTextColor.RED));
                    }
                });
            } else {
                Util.update(api, Util.ResultType.TAG, Util.unchanged);
            }
            if (info == null || !info.getPosition().equals(this.position.get())) {
                api.getApiHandler().setPosition((GlobalPosition)this.position.get(), response -> {
                    if (response.isSuccessful()) {
                        Util.update(api, Util.ResultType.POSITION, TICK);
                    } else {
                        Util.update(api, Util.ResultType.POSITION, (Component)Component.text((String)response.getError(), (TextColor)NamedTextColor.RED));
                    }
                });
            } else {
                Util.update(api, Util.ResultType.POSITION, Util.unchanged);
            }
            if (info == null || !info.getGlobalIconType().equals(this.icon.get())) {
                api.getApiHandler().setIcon((GlobalIcon)this.icon.get(), response -> {
                    if (response.isSuccessful()) {
                        Util.update(api, Util.ResultType.ICON, TICK);
                    } else {
                        Util.update(api, Util.ResultType.ICON, (Component)Component.text((String)response.getError(), (TextColor)NamedTextColor.RED));
                    }
                });
            } else {
                Util.update(api, Util.ResultType.ICON, Util.unchanged);
            }
            if (info == null || info.isRoleIconHidden() != ((Boolean)this.hideRoleIcon.get()).booleanValue()) {
                api.getApiHandler().setRoleIconVisibility((Boolean)this.hideRoleIcon.get() == false, response -> {
                    if (response.isSuccessful()) {
                        Util.update(api, Util.ResultType.ROLE_ICON_VISIBILITY, TICK);
                    } else {
                        Util.update(api, Util.ResultType.ROLE_ICON_VISIBILITY, (Component)Component.text((String)response.getError(), (TextColor)NamedTextColor.RED));
                    }
                });
            } else {
                Util.update(api, Util.ResultType.ROLE_ICON_VISIBILITY, Util.unchanged);
            }
        });
    }

    @MethodOrder(after="updateSettings")
    @SpriteSlot(size=32, x=3, y=1)
    @ButtonWidget.ButtonSetting
    public void resetTag(Setting setting) {
        GlobalTagAPI api = GlobalTagsAddon.getAPI();
        api.getApiHandler().resetTag(info -> {
            if (info.isSuccessful()) {
                Util.broadcastTagUpdate();
                Laby.fireEvent((Event)new RefreshInfoEvent(true));
            }
            Util.sendResponseNotification((ApiResponse<String>)info);
        });
    }

    public ConfigProperty<String> tag() {
        return this.tag;
    }

    public ConfigProperty<GlobalPosition> position() {
        return this.position;
    }

    public ConfigProperty<GlobalIcon> icon() {
        return this.icon;
    }

    public ConfigProperty<Boolean> hideRoleIcon() {
        return this.hideRoleIcon;
    }
}

