/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.interaction;

import com.rappytv.globaltags.api.Textures;
import com.rappytv.globaltags.api.Util;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.core.config.GlobalTagsConfig;
import com.rappytv.globaltags.wrapper.enums.GlobalPermission;
import com.rappytv.globaltags.wrapper.http.ApiResponse;
import com.rappytv.globaltags.wrapper.model.PlayerInfo;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.interaction.BulletPoint;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.resources.ResourceLocation;

public class ClearTagBulletPoint
implements BulletPoint {
    private final GlobalTagsConfig config;

    public ClearTagBulletPoint(GlobalTagsAddon addon) {
        this.config = (GlobalTagsConfig)addon.configuration();
    }

    public Component getTitle() {
        return Component.translatable((String)"globaltags.context.clearTag.name", (Component[])new Component[0]);
    }

    public Icon getIcon() {
        return Icon.texture((ResourceLocation)Textures.ICON_ROUND);
    }

    public void execute(Player player) {
        GlobalTagsAddon.getAPI().getApiHandler().resetTag(player.getUniqueId(), response -> Laby.references().chatExecutor().displayClientMessage(((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append(Util.getResponseComponent((ApiResponse<String>)response))));
    }

    public boolean isVisible(Player player) {
        if (!((Boolean)this.config.enabled().get()).booleanValue() || !((Boolean)this.config.showBulletPoints().get()).booleanValue()) {
            return false;
        }
        PlayerInfo executor = GlobalTagsAddon.getAPI().getCache().get(Laby.labyAPI().getUniqueId());
        PlayerInfo target = GlobalTagsAddon.getAPI().getCache().get(player.getUniqueId());
        return executor != null && executor.hasPermission(GlobalPermission.MANAGE_TAGS) && target != null && target.getTag() != null;
    }
}

