/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.interaction;

import com.rappytv.globaltags.api.Textures;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.core.config.GlobalTagsConfig;
import com.rappytv.globaltags.core.ui.activities.interaction.ReportActivity;
import com.rappytv.globaltags.wrapper.model.PlayerInfo;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.interaction.BulletPoint;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.resources.ResourceLocation;

public class ReportBulletPoint
implements BulletPoint {
    private final GlobalTagsConfig config;

    public ReportBulletPoint(GlobalTagsAddon addon) {
        this.config = (GlobalTagsConfig)addon.configuration();
    }

    public Component getTitle() {
        return Component.translatable((String)"globaltags.context.report.name", (Component[])new Component[0]);
    }

    public Icon getIcon() {
        return Icon.texture((ResourceLocation)Textures.ICON_ROUND);
    }

    public void execute(Player player) {
        Laby.labyAPI().minecraft().executeNextTick(() -> Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)new ReportActivity(this.config, player.getUniqueId(), player.getName())));
    }

    public boolean isVisible(Player player) {
        if (!((Boolean)this.config.enabled().get()).booleanValue() || !((Boolean)this.config.showBulletPoints().get()).booleanValue()) {
            return false;
        }
        PlayerInfo playerInfo = GlobalTagsAddon.getAPI().getCache().get(player.getUniqueId());
        return playerInfo != null && playerInfo.getTag() != null;
    }
}

