/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.activities.config;

import com.rappytv.globaltags.core.config.GlobalTagsConfig;
import com.rappytv.globaltags.core.ui.widgets.config.HiddenPlayerWidget;
import java.util.UUID;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;

@Link(value="player-list.lss")
@AutoActivity
public class HiddenTagListActivity
extends SimpleActivity {
    private final VerticalListWidget<HiddenPlayerWidget> entries = (VerticalListWidget)new VerticalListWidget().addId("player-entries");
    private ScrollWidget scrollWidget;
    private ComponentWidget errorComponent;

    public HiddenTagListActivity(GlobalTagsConfig config) {
        for (UUID uuid : config.hiddenTags()) {
            this.entries.addChild((Widget)new HiddenPlayerWidget(uuid, config, widget -> {
                this.entries.removeChild((Widget)widget);
                this.setVisibility();
            }));
        }
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget container = (FlexibleContentWidget)new FlexibleContentWidget().addId("container");
        this.scrollWidget = new ScrollWidget(this.entries);
        this.errorComponent = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.settings.hiddenTagList.empty", (TextColor)NamedTextColor.RED).addId("error-component");
        container.addContent((Widget)this.scrollWidget);
        container.addContent((Widget)this.errorComponent);
        this.setVisibility();
        ((Document)this.document).addChild((Widget)container);
    }

    public void setVisibility() {
        boolean isEmpty = this.entries.getChildren().isEmpty();
        this.scrollWidget.setVisible(!isEmpty);
        this.errorComponent.setVisible(isEmpty);
    }
}

