/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.activities.config;

import com.rappytv.globaltags.api.Util;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.core.config.subconfig.AccountConfig;
import com.rappytv.globaltags.core.ui.widgets.config.TagPreviewWidget;
import com.rappytv.globaltags.wrapper.enums.GlobalIcon;
import com.rappytv.globaltags.wrapper.model.PlayerInfo;
import java.util.Arrays;
import java.util.List;
import net.labymod.api.Laby;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.color.ColorPickerWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.util.Color;
import net.labymod.api.util.Debounce;

@Link(value="tag-editor.lss")
@AutoActivity
public class TagEditorActivity
extends SimpleActivity {
    private static final List<ColorEntry> numberColors = Arrays.asList(new ColorEntry(Character.valueOf('0'), NamedTextColor.BLACK), new ColorEntry(Character.valueOf('1'), NamedTextColor.DARK_BLUE), new ColorEntry(Character.valueOf('2'), NamedTextColor.DARK_GREEN), new ColorEntry(Character.valueOf('3'), NamedTextColor.DARK_AQUA), new ColorEntry(Character.valueOf('4'), NamedTextColor.DARK_RED), new ColorEntry(Character.valueOf('5'), NamedTextColor.DARK_PURPLE), new ColorEntry(Character.valueOf('6'), NamedTextColor.GOLD), new ColorEntry(Character.valueOf('7'), NamedTextColor.GRAY), new ColorEntry(Character.valueOf('8'), NamedTextColor.DARK_GRAY), new ColorEntry(Character.valueOf('9'), NamedTextColor.BLUE));
    private static final List<ColorEntry> symbolColors = Arrays.asList(new ColorEntry(Character.valueOf('a'), NamedTextColor.GREEN), new ColorEntry(Character.valueOf('b'), NamedTextColor.AQUA), new ColorEntry(Character.valueOf('c'), NamedTextColor.RED), new ColorEntry(Character.valueOf('d'), NamedTextColor.LIGHT_PURPLE), new ColorEntry(Character.valueOf('e'), NamedTextColor.YELLOW), new ColorEntry(Character.valueOf('f'), NamedTextColor.WHITE));
    private static final List<DecorationEntry> decorations = Arrays.asList(new DecorationEntry(Character.valueOf('k'), TextDecoration.OBFUSCATED), new DecorationEntry(Character.valueOf('l'), TextDecoration.BOLD), new DecorationEntry(Character.valueOf('m'), TextDecoration.STRIKETHROUGH), new DecorationEntry(Character.valueOf('n'), TextDecoration.UNDERLINED), new DecorationEntry(Character.valueOf('o'), TextDecoration.ITALIC));
    private final AccountConfig config;
    private final Component errorComponent;
    private final TagPreviewWidget previewWidget;
    private TextFieldWidget editorTextField;

    public TagEditorActivity() {
        this.config = null;
        this.errorComponent = Component.translatable((String)"globaltags.settings.account.tagEditor.error", (Component[])new Component[0]);
        this.previewWidget = null;
    }

    public TagEditorActivity(PlayerInfo<?> info, AccountConfig config) {
        this.config = config;
        this.errorComponent = null;
        String iconUrl = TagPreviewWidget.getIconUrl(info, (GlobalIcon)config.icon().get());
        if (info == null) {
            this.previewWidget = new TagPreviewWidget((String)config.tag().get(), iconUrl != null ? Icon.url((String)iconUrl) : null, null);
            return;
        }
        this.previewWidget = new TagPreviewWidget((String)config.tag().get(), iconUrl != null ? Icon.url((String)iconUrl) : null, (Boolean)config.hideRoleIcon().get() != false ? null : (info.getRoleIcon() != null ? Icon.url((String)GlobalTagsAddon.getAPI().getUrls().getRoleIcon(info.getRoleIcon())) : null));
    }

    public void initialize(Parent parent) {
        ComponentWidget colorButton;
        String label;
        super.initialize(parent);
        if (this.errorComponent != null) {
            ((Document)this.document).addChild(ComponentWidget.component((Component)this.errorComponent).addId("error"));
            return;
        }
        FlexibleContentWidget container = (FlexibleContentWidget)new FlexibleContentWidget().addId("container");
        FlexibleContentWidget previewWrapper = (FlexibleContentWidget)new FlexibleContentWidget().addId("preview");
        ComponentWidget previewComponent = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.settings.account.tagEditor.preview").addId("heading");
        previewWrapper.addContent((Widget)previewComponent);
        previewWrapper.addContent((Widget)this.previewWidget);
        FlexibleContentWidget editorWrapper = (FlexibleContentWidget)new FlexibleContentWidget().addId("editor");
        ComponentWidget editorComponent = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.settings.account.tagEditor.editor").addId("heading");
        this.editorTextField = (TextFieldWidget)new TextFieldWidget().addId("editor-input");
        this.addText((String)this.config.tag().get());
        this.editorTextField.updateListener(text -> {
            this.previewWidget.updateTag((String)text);
            Debounce.of((String)"globaltags-tag-editor", (long)2000L, () -> {
                this.config.tag().set((Object)this.editorTextField.getText());
                Util.notify((Component)Component.translatable((String)"globaltags.settings.account.save.title", (Component[])new Component[0]), (Component)Component.translatable((String)"globaltags.settings.account.save.description", (Component[])new Component[]{Component.translatable((String)"globaltags.settings.account.updateSettings.name", (Component[])new Component[0])}));
            });
        });
        editorWrapper.addContent((Widget)editorComponent);
        editorWrapper.addContent((Widget)this.editorTextField);
        FlexibleContentWidget utilsWrapper = (FlexibleContentWidget)new FlexibleContentWidget().addId("utils");
        ComponentWidget utilsComponent = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.settings.account.tagEditor.utils").addId("heading");
        HorizontalListWidget utilsLine1 = new HorizontalListWidget();
        HorizontalListWidget utilsLine2 = new HorizontalListWidget();
        HorizontalListWidget utilsLine3 = new HorizontalListWidget();
        for (ColorEntry colorEntry : numberColors) {
            label = "&" + colorEntry.character;
            colorButton = (ComponentWidget)ComponentWidget.text((String)label, (TextColor)colorEntry.color).addId("color-button");
            colorButton.setPressable(() -> this.addText(label));
            utilsLine1.addEntry((Widget)colorButton);
        }
        for (ColorEntry colorEntry : symbolColors) {
            label = "&" + colorEntry.character;
            colorButton = (ComponentWidget)ComponentWidget.text((String)label, (TextColor)colorEntry.color).addId("color-button");
            colorButton.setPressable(() -> this.addText(label));
            utilsLine2.addEntry((Widget)colorButton);
        }
        for (DecorationEntry decorationEntry : decorations) {
            label = "&" + decorationEntry.character;
            colorButton = (ComponentWidget)ComponentWidget.component((Component)Component.text((String)label).decorate(decorationEntry.decoration)).addId("color-button");
            colorButton.setPressable(() -> this.addText(label));
            utilsLine3.addEntry((Widget)colorButton);
        }
        HorizontalListWidget utilSquareWrapper = (HorizontalListWidget)new HorizontalListWidget().addId("square-wrapper");
        ColorPickerWidget colorPickerWidget = ColorPickerWidget.of((Color)Color.WHITE);
        colorPickerWidget.addUpdateListener((Object)colorPickerWidget, color -> Debounce.of((String)"globaltags-colorpicker", (long)1000L, () -> this.addText(String.format("<#%06X>", 0xFFFFFF & color.get()))));
        ButtonWidget utilsGradientButton = (ButtonWidget)ButtonWidget.icon((Icon)Textures.SpriteCommon.PAINT, () -> Laby.references().chatExecutor().openUrl("https://globaltags.xyz/gradients", false)).addId("gradient-button");
        colorPickerWidget.setHoverComponent((Component)Component.translatable((String)"globaltags.settings.account.tagEditor.hexChooser", (Component[])new Component[0]));
        utilsGradientButton.setHoverComponent((Component)Component.translatable((String)"globaltags.settings.account.tagEditor.gradientGenerator", (Component[])new Component[0]));
        utilSquareWrapper.addEntry((Widget)colorPickerWidget);
        utilSquareWrapper.addEntry((Widget)utilsGradientButton);
        utilsWrapper.addContent((Widget)utilsComponent);
        utilsWrapper.addContent((Widget)utilsLine1);
        utilsWrapper.addContent((Widget)utilsLine2);
        utilsWrapper.addContent((Widget)utilsLine3);
        utilsWrapper.addContent((Widget)utilSquareWrapper);
        container.addContent((Widget)previewWrapper);
        container.addContent((Widget)editorWrapper);
        container.addContent((Widget)utilsWrapper);
        ((Document)this.document).addChild((Widget)container);
    }

    private void addText(String text) {
        this.editorTextField.setText(this.editorTextField.getText() + text);
        this.editorTextField.setFocused(true);
        this.editorTextField.setCursorAtEnd();
    }

    private record ColorEntry(Character character, TextColor color) {
    }

    private record DecorationEntry(Character character, TextDecoration decoration) {
    }
}

