/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.activities.interaction;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.core.ui.activities.interaction.CreateNoteActivity;
import com.rappytv.globaltags.core.ui.widgets.interaction.StaffNoteWidget;
import com.rappytv.globaltags.wrapper.model.PlayerNote;
import java.util.List;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.ScrollWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;

@Link(value="list.lss")
@AutoActivity
public class StaffNotesActivity
extends SimpleActivity {
    private final GlobalTagAPI api = GlobalTagsAddon.getAPI();
    private final UUID uuid;
    private final String username;

    public StaffNotesActivity(UUID uuid, String username) {
        this.uuid = uuid;
        this.username = username;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        this.api.getApiHandler().getNotes(this.uuid, response -> Laby.labyAPI().minecraft().executeOnRenderThread(() -> {
            if (((Document)this.document).getChild("window") != null) {
                return;
            }
            if (!response.isSuccessful()) {
                Laby.references().chatExecutor().displayClientMessage((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().append(GlobalTagsAddon.prefix())).append((Component)Component.text((String)response.getError(), (TextColor)NamedTextColor.RED))).build());
                Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)null);
                return;
            }
            FlexibleContentWidget windowWidget = (FlexibleContentWidget)new FlexibleContentWidget().addId("window");
            HorizontalListWidget profileWrapper = (HorizontalListWidget)new HorizontalListWidget().addId("header");
            ButtonWidget createButton = (ButtonWidget)ButtonWidget.text((String)"+", () -> Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)new CreateNoteActivity(this.api, this.uuid, this.username))).addId("create-button");
            createButton.setHoverComponent((Component)Component.translatable((String)"globaltags.context.staffNotes.hover.create", (Component[])new Component[0]));
            IconWidget headWidget = (IconWidget)new IconWidget(Icon.head((UUID)this.uuid)).addId("head");
            ComponentWidget titleWidget = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.context.staffNotes.title", (Object[])new Object[]{this.username}).addId("username");
            VerticalListWidget notes = (VerticalListWidget)new VerticalListWidget().addId("item-list");
            for (PlayerNote note : (List)response.getData()) {
                notes.addChild((Widget)new StaffNoteWidget(this.uuid, this.api, note));
            }
            profileWrapper.addEntryInitialized((Widget)headWidget);
            profileWrapper.addEntryInitialized((Widget)titleWidget);
            profileWrapper.addEntryInitialized((Widget)createButton);
            windowWidget.addContentInitialized((Widget)profileWrapper);
            windowWidget.addContentInitialized((Widget)new ScrollWidget(notes));
            ((Document)this.document).addChildInitialized((Widget)windowWidget);
        }));
    }
}

