/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.widgets.config;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.api.Util;
import com.rappytv.globaltags.wrapper.http.ApiResponse;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.popup.AdvancedPopup;
import org.jetbrains.annotations.Nullable;

public class AppealPopup
extends AdvancedPopup {
    private final GlobalTagAPI api;

    public AppealPopup(GlobalTagAPI api) {
        this.api = api;
    }

    @Nullable
    public Widget initialize() {
        VerticalListWidget content = (VerticalListWidget)new VerticalListWidget().addId("content");
        ComponentWidget labelWidget = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.settings.account.accountInfo.appeal.popup.label").addId(new String[]{"label", "popup-description"});
        TextFieldWidget inputWidget = (TextFieldWidget)new TextFieldWidget().placeholder((Component)Component.translatable((String)"globaltags.settings.account.accountInfo.appeal.popup.placeholder", (TextColor)NamedTextColor.DARK_GRAY)).addId(new String[]{"input", "popup-description"});
        ButtonWidget sendButton = (ButtonWidget)new ButtonWidget().updateComponent((Component)Component.translatable((String)"globaltags.settings.account.accountInfo.appeal.popup.button", (TextColor)NamedTextColor.RED)).addId(new String[]{"send-button", "popup-description"});
        sendButton.setEnabled(false);
        sendButton.setActionListener(() -> {
            this.api.getApiHandler().appealBan(inputWidget.getText(), response -> Util.notify((Component)Component.translatable((String)(response.isSuccessful() ? "globaltags.general.success" : "globaltags.general.error"), (Component[])new Component[0]), Util.getResponseComponent((ApiResponse<String>)response).color(NamedTextColor.WHITE)));
            this.close();
        });
        inputWidget.updateListener(text -> sendButton.setEnabled(!text.isBlank()));
        content.addChild((Widget)labelWidget);
        content.addChild((Widget)inputWidget);
        content.addChild((Widget)sendButton);
        return content;
    }
}

