/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.widgets.config;

import com.rappytv.globaltags.wrapper.model.ReferralLeaderboardEntry;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.util.ThreadSafe;

@AutoWidget
public class ReferralLeaderboardEntryWidget
extends HorizontalListWidget {
    private final ReferralLeaderboardEntry entry;

    public ReferralLeaderboardEntryWidget(ReferralLeaderboardEntry entry) {
        this.entry = entry;
    }

    public void initialize(Parent parent) {
        if (this.isInitialized()) {
            return;
        }
        super.initialize(parent);
        IconWidget headWidget = (IconWidget)new IconWidget(Icon.head((UUID)this.entry.getUUID())).addId("player-head");
        ComponentWidget text = (ComponentWidget)ComponentWidget.component((Component)this.getUsernameComponent(true, null)).addId("username-component");
        ComponentWidget value = (ComponentWidget)ComponentWidget.component((Component)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)Component.translatable((String)"globaltags.settings.referralLeaderboards.activity.total", (Component[])new Component[0]))).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((Object)this.entry.getTotalReferrals(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.newline())).append((Component)Component.translatable((String)"globaltags.settings.referralLeaderboards.activity.currentMonth", (Component[])new Component[0]))).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((Object)this.entry.getCurrentMonthReferrals(), (TextColor)NamedTextColor.AQUA))).addId("referral-count-component");
        this.addEntry((Widget)headWidget);
        this.addEntry((Widget)text);
        this.addEntry((Widget)value);
        Laby.references().labyNetController().loadNameByUniqueId(this.entry.getUUID(), name -> {
            if (ThreadSafe.isRenderThread()) {
                text.setComponent(this.getUsernameComponent(false, (String)name.getNullable()));
                text.addId("loaded");
            } else {
                Laby.labyAPI().minecraft().executeOnRenderThread(() -> {
                    text.setComponent(this.getUsernameComponent(false, (String)name.getNullable()));
                    text.addId("loaded");
                });
            }
        });
    }

    private Component getUsernameComponent(boolean loading, String username) {
        Component component = ((TextComponent)Component.empty().append((Component)Component.text((String)(this.entry.getRank() + ". "), (TextColor)NamedTextColor.AQUA))).clickEvent(ClickEvent.openUrl((String)("https://laby.net/@" + String.valueOf(this.entry.getUUID()))));
        if (loading) {
            component.append((Component)Component.translatable((String)"globaltags.settings.referralLeaderboards.activity.loading", (TextColor)NamedTextColor.GRAY));
        } else if (username == null) {
            component.append((Component)Component.translatable((String)"globaltags.settings.referralLeaderboards.activity.open", (Component[])new Component[0]));
        } else {
            component.append((Component)Component.text((String)username));
        }
        return component;
    }
}

