/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.widgets.interaction;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.wrapper.model.TagHistoryEntry;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.SimpleWidget;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;

@AutoWidget
public class TagHistoryEntryWidget
extends SimpleWidget {
    private final int number;
    private final GlobalTagAPI api;
    private final TagHistoryEntry entry;

    public TagHistoryEntryWidget(int number, GlobalTagAPI api, TagHistoryEntry entry) {
        this.number = number;
        this.api = api;
        this.entry = entry;
    }

    public void initialize(Parent parent) {
        if (this.isInitialized()) {
            return;
        }
        super.initialize(parent);
        ComponentWidget text = (ComponentWidget)ComponentWidget.component((Component)((TextComponent)Component.empty().append((Component)Component.text((String)(this.number + ". "), (TextColor)NamedTextColor.AQUA))).append(this.api.translateColorCodes(this.entry.getTag()))).addId("text-component");
        this.addChild((Widget)text);
        if (!this.entry.getFlaggedWords().isEmpty()) {
            TranslatableComponent hoverComponent = Component.translatable((String)"globaltags.context.tagHistory.flaggedWords", (TextColor)NamedTextColor.GOLD);
            for (String word : this.entry.getFlaggedWords()) {
                hoverComponent.append((Component)Component.newline()).append((Component)Component.text((String)("- " + word), (TextColor)NamedTextColor.GOLD));
            }
            ComponentWidget flaggedWords = (ComponentWidget)ComponentWidget.text((String)"\u26a0", (TextColor)NamedTextColor.GOLD).addId("flagged-words");
            flaggedWords.setHoverComponent((Component)hoverComponent);
            this.addChild((Widget)flaggedWords);
        }
    }
}

