/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.api;

import com.rappytv.globaltags.api.GlobalTagDeserializer;
import com.rappytv.globaltags.wrapper.GlobalTagsAPI;
import com.rappytv.globaltags.wrapper.enums.AuthProvider;
import java.util.UUID;
import java.util.function.Supplier;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.labyconnect.LabyConnectSession;
import net.labymod.api.labyconnect.TokenStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalTagAPI
extends GlobalTagsAPI<Component> {
    private final GlobalTagsAPI.Agent agent;
    private final Supplier<String> language;

    public GlobalTagAPI(GlobalTagsAPI.Agent agent, Supplier<String> language) {
        this.agent = agent;
        this.language = language;
    }

    @NotNull
    public GlobalTagsAPI.Agent getAgent() {
        return this.agent;
    }

    @NotNull
    public String getLanguageCode() {
        return this.language.get();
    }

    @NotNull
    public Component translateColorCodes(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return Component.empty();
        }
        return GlobalTagDeserializer.deserialize(string);
    }

    @Nullable
    public UUID getClientUUID() {
        return Laby.labyAPI().getUniqueId();
    }

    @NotNull
    public AuthProvider getAuthType() {
        return AuthProvider.LABYCONNECT;
    }

    @Nullable
    public String getAuthorization() {
        LabyConnectSession session = Laby.labyAPI().labyConnect().getSession();
        if (session == null) {
            return null;
        }
        TokenStorage.Token token = session.tokenStorage().getToken(TokenStorage.Purpose.JWT, session.self().getUniqueId());
        if (token == null || token.isExpired()) {
            return null;
        }
        return token.getToken();
    }
}

