/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.api.event.RefreshInfoEvent;
import com.rappytv.globaltags.wrapper.http.ApiResponse;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.screen.widget.widgets.popup.SimpleAdvancedPopup;
import net.labymod.api.event.Event;
import net.labymod.api.labyconnect.LabyConnectSession;
import net.labymod.api.notification.Notification;

public class Util {
    public static final Component unchanged = Component.translatable((String)"globaltags.settings.account.updateSettings.unchanged", (TextColor)NamedTextColor.DARK_GRAY);
    private static Component tagResponse = null;
    private static Component positionResponse = null;
    private static Component iconResponse = null;
    private static Component roleIconVisibilityResponse = null;

    public static void update(GlobalTagAPI api, ResultType type, Component component) {
        switch (type.ordinal()) {
            case 0: {
                tagResponse = component;
                break;
            }
            case 1: {
                positionResponse = component;
                break;
            }
            case 2: {
                iconResponse = component;
                break;
            }
            case 3: {
                roleIconVisibilityResponse = component;
            }
        }
        if (tagResponse == null || positionResponse == null || iconResponse == null || roleIconVisibilityResponse == null) {
            return;
        }
        SimpleAdvancedPopup popup = SimpleAdvancedPopup.builder().title((Component)Component.translatable((String)"globaltags.settings.account.updateSettings.result", (TextColor)NamedTextColor.AQUA)).description(((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)Component.translatable((String)"globaltags.settings.account.updateSettings.tag", (Component[])new Component[]{tagResponse}))).append((Component)Component.newline())).append((Component)Component.translatable((String)"globaltags.settings.account.updateSettings.position", (Component[])new Component[]{positionResponse}))).append((Component)Component.newline())).append((Component)Component.translatable((String)"globaltags.settings.account.updateSettings.icon", (Component[])new Component[]{iconResponse}))).append((Component)Component.newline())).append((Component)Component.translatable((String)"globaltags.settings.account.updateSettings.roleIconVisibility", (Component[])new Component[]{roleIconVisibilityResponse}))).addButton(SimpleAdvancedPopup.SimplePopupButton.confirm()).build();
        Laby.labyAPI().minecraft().executeOnRenderThread(() -> {
            popup.displayInOverlay();
            api.getCache().renewSelf();
            Util.broadcastTagUpdate();
            Laby.fireEvent((Event)new RefreshInfoEvent());
            tagResponse = null;
            positionResponse = null;
            iconResponse = null;
            roleIconVisibilityResponse = null;
        });
    }

    public static void sendResponseNotification(ApiResponse<String> response) {
        Util.notify((Component)Component.translatable((String)("globaltags.general." + (response.isSuccessful() ? "success" : "error")), (Component[])new Component[0]), (Component)Component.text((String)(response.isSuccessful() ? (String)response.getData() : response.getError())));
    }

    public static void notify(String title, String text) {
        Util.notify((Component)Component.text((String)title), (Component)Component.text((String)text));
    }

    public static void notify(Component title, Component description) {
        Notification.builder().title(title).text(description).type(Notification.Type.SYSTEM).buildAndPush();
    }

    public static Component getResponseComponent(ApiResponse<String> response) {
        return Component.text((String)(response.isSuccessful() ? (String)response.getData() : response.getError()), (TextColor)(response.isSuccessful() ? NamedTextColor.GREEN : NamedTextColor.RED));
    }

    public static void broadcastTagUpdate() {
        Util.broadcastTagUpdate(null);
    }

    public static void broadcastTagUpdate(UUID uuid) {
        LabyConnectSession session;
        JsonObject object = new JsonObject();
        if (uuid != null) {
            object.add("uuid", (JsonElement)new JsonPrimitive(uuid.toString()));
        }
        if ((session = Laby.labyAPI().labyConnect().getSession()) == null) {
            return;
        }
        session.sendBroadcastPayload("globaltags", (JsonElement)object);
    }

    public static enum ResultType {
        TAG,
        POSITION,
        ICON,
        ROLE_ICON_VISIBILITY;

    }
}

