/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.core.command.GlobalTagCommand;
import com.rappytv.globaltags.core.config.GlobalTagsConfig;
import com.rappytv.globaltags.core.interaction.ChangeTagBulletPoint;
import com.rappytv.globaltags.core.interaction.ClearTagBulletPoint;
import com.rappytv.globaltags.core.interaction.EditBanInfoBulletPoint;
import com.rappytv.globaltags.core.interaction.ReferPlayerBulletPoint;
import com.rappytv.globaltags.core.interaction.ReportBulletPoint;
import com.rappytv.globaltags.core.interaction.StaffNotesBulletPoint;
import com.rappytv.globaltags.core.interaction.TagHistoryBulletPoint;
import com.rappytv.globaltags.core.interaction.ToggleBanBulletPoint;
import com.rappytv.globaltags.core.interaction.ToggleHideTagBulletPoint;
import com.rappytv.globaltags.core.listeners.BroadcastListener;
import com.rappytv.globaltags.core.listeners.LabyConnectDisconnectListener;
import com.rappytv.globaltags.core.listeners.ServerNavigationListener;
import com.rappytv.globaltags.core.listeners.WorldEnterListener;
import com.rappytv.globaltags.core.ui.activities.config.ReferralLeaderboardActivity;
import com.rappytv.globaltags.core.ui.nametag.GlobalTagNameTag;
import com.rappytv.globaltags.wrapper.GlobalTagsAPI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.labymod.api.Laby;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.component.format.TextDecoration;
import net.labymod.api.client.entity.player.tag.PositionType;
import net.labymod.api.client.entity.player.tag.TagRegistry;
import net.labymod.api.client.entity.player.tag.renderer.TagRenderer;
import net.labymod.api.models.addon.annotation.AddonMain;
import net.labymod.api.revision.Revision;
import net.labymod.api.revision.SimpleRevision;
import net.labymod.api.util.concurrent.task.Task;
import net.labymod.api.util.version.SemanticVersion;

@AddonMain
public class GlobalTagsAddon
extends LabyAddon<GlobalTagsConfig> {
    private static final Component prefix = ((TextComponent)Component.empty().append(((TextComponent)Component.text((String)"GlobalTags").color(NamedTextColor.BLUE)).decorate(TextDecoration.BOLD))).append((Component)Component.text((String)" \u00bb ", (TextColor)NamedTextColor.DARK_GRAY));
    private static GlobalTagsAddon instance;
    private static GlobalTagAPI api;
    private static final String[][] versions;

    protected void preConfigurationLoad() {
        for (String[] version : versions) {
            Laby.references().revisionRegistry().register((Revision)new SimpleRevision("globaltags", new SemanticVersion(version[0]), version[1]));
        }
    }

    protected void enable() {
        instance = this;
        this.registerSettingCategory();
        api = new GlobalTagAPI(new GlobalTagsAPI.Agent("LabyAddon", this.addonInfo().getVersion(), Laby.labyAPI().minecraft().getVersion()), () -> (Boolean)((GlobalTagsConfig)this.configuration()).localizedResponses().get() != false ? Laby.labyAPI().minecraft().options().getCurrentLanguage() : "en_us");
        this.registerCommand(new GlobalTagCommand(this));
        this.registerListener(new BroadcastListener(api));
        this.registerListener(new LabyConnectDisconnectListener(api));
        this.registerListener(new ServerNavigationListener());
        this.registerListener(new WorldEnterListener());
        this.labyAPI().interactionMenuRegistry().register((Object)new ChangeTagBulletPoint(this));
        this.labyAPI().interactionMenuRegistry().register((Object)new ClearTagBulletPoint(this));
        this.labyAPI().interactionMenuRegistry().register((Object)new EditBanInfoBulletPoint(this));
        this.labyAPI().interactionMenuRegistry().register((Object)new ReferPlayerBulletPoint(this));
        this.labyAPI().interactionMenuRegistry().register((Object)new ReportBulletPoint(this));
        this.labyAPI().interactionMenuRegistry().register((Object)new StaffNotesBulletPoint(this));
        this.labyAPI().interactionMenuRegistry().register((Object)new TagHistoryBulletPoint(this));
        this.labyAPI().interactionMenuRegistry().register((Object)new ToggleBanBulletPoint(this));
        this.labyAPI().interactionMenuRegistry().register((Object)new ToggleHideTagBulletPoint(this));
        TagRegistry tagRegistry = this.labyAPI().tagRegistry();
        for (PositionType positionType : PositionType.values()) {
            tagRegistry.registerAfter("labymod_role", "globaltags_tag_" + positionType.name().split("_")[0].toLowerCase(), positionType, (TagRenderer)new GlobalTagNameTag(positionType, () -> Float.valueOf((float)((Integer)((GlobalTagsConfig)this.configuration()).tagSize().get()).intValue() / 10.0f)));
        }
        Task.builder(() -> api.getApiHandler().getReferralLeaderboards(response -> {
            if (!response.isSuccessful()) {
                return;
            }
            ReferralLeaderboardActivity.setLeaderboards((Map)response.getData());
        })).repeat(5L, TimeUnit.MINUTES).build().execute();
    }

    protected Class<? extends GlobalTagsConfig> configurationClass() {
        return GlobalTagsConfig.class;
    }

    public static GlobalTagsConfig config() {
        return (GlobalTagsConfig)instance.configuration();
    }

    public static Component prefix() {
        return prefix.copy();
    }

    public static GlobalTagAPI getAPI() {
        return api;
    }

    static {
        versions = new String[][]{{"1.1.0", "2023-11-24"}, {"1.1.7", "2024-02-27"}, {"1.1.9", "2024-06-01"}, {"1.2.0", "2024-07-14"}, {"1.3.5", "2024-12-15"}, {"1.4.0", "2025-03-01"}, {"1.4.1", "2025-04-10"}, {"1.4.3", "2025-05-20"}};
    }
}

