/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.command.subcommands;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.api.Util;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.wrapper.http.schemas.GiftCodeRedeemSchema;
import java.text.SimpleDateFormat;
import net.labymod.api.client.chat.command.SubCommand;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;

public class RedeemCommand
extends SubCommand {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    private final GlobalTagAPI api;

    public RedeemCommand(GlobalTagAPI api) {
        super("redeem", new String[0]);
        this.api = api;
        this.translationKey("globaltags.commands.redeem");
    }

    public boolean execute(String prefix, String[] arguments) {
        if (arguments.length < 1) {
            this.displayMessage(((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append((Component)Component.translatable((String)this.getTranslationKey("enterCode"), (TextColor)NamedTextColor.RED)));
            return true;
        }
        String code = arguments[0];
        this.api.getApiHandler().redeemGiftCode(code, response -> {
            if (!response.isSuccessful()) {
                this.displayMessage(((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append((Component)Component.text((String)response.getError(), (TextColor)NamedTextColor.RED)));
                return;
            }
            GiftCodeRedeemSchema data = (GiftCodeRedeemSchema)response.getData();
            Component component = ((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append((Component)Component.text((String)data.getMessage(), (TextColor)NamedTextColor.GREEN));
            if (data.getExpiresAt() != null) {
                component.append((Component)Component.space()).append((Component)Component.translatable((String)this.getTranslationKey("expiration"), (TextColor)NamedTextColor.GREEN, (Component[])new Component[]{Component.text((String)dateFormat.format(data.getExpiresAt()), (TextColor)NamedTextColor.AQUA)}));
            }
            this.displayMessage(component);
            this.api.getCache().renewSelf();
            Util.broadcastTagUpdate();
        });
        return true;
    }
}

