/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.activities.config;

import com.rappytv.globaltags.api.Util;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.core.config.subconfig.AccountConfig;
import com.rappytv.globaltags.core.ui.widgets.config.TagPreviewWidget;
import com.rappytv.globaltags.wrapper.enums.GlobalIcon;
import com.rappytv.globaltags.wrapper.enums.GlobalPermission;
import com.rappytv.globaltags.wrapper.http.schemas.IconUploadSchema;
import com.rappytv.globaltags.wrapper.model.PlayerInfo;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.labymod.api.Laby;
import net.labymod.api.Textures;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.mouse.MutableMouse;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.dropdown.DropdownWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.models.OperatingSystem;
import net.labymod.api.util.Debounce;
import net.labymod.api.util.I18n;

@Link(value="icon-chooser.lss")
@AutoActivity
public class IconSelectorActivity
extends SimpleActivity {
    private final PlayerInfo<?> info;
    private final AccountConfig config;
    private final Component errorComponent;
    private final TagPreviewWidget previewWidget;

    public IconSelectorActivity() {
        this.info = null;
        this.config = null;
        this.errorComponent = Component.translatable((String)"globaltags.settings.account.tagEditor.error", (Component[])new Component[0]);
        this.previewWidget = null;
    }

    public IconSelectorActivity(PlayerInfo<?> info, AccountConfig config) {
        this.info = info;
        this.config = config;
        this.errorComponent = null;
        String iconUrl = TagPreviewWidget.getIconUrl(info, (GlobalIcon)config.icon().get());
        if (info == null) {
            this.previewWidget = new TagPreviewWidget((String)config.tag().get(), iconUrl != null ? Icon.url((String)iconUrl) : null, null);
            return;
        }
        this.previewWidget = new TagPreviewWidget((String)config.tag().get(), iconUrl != null ? Icon.url((String)iconUrl) : null, (Boolean)config.hideRoleIcon().get() != false ? null : (info.getRoleIcon() != null ? Icon.url((String)GlobalTagsAddon.getAPI().getUrls().getRoleIcon(info.getRoleIcon())) : null));
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        if (this.errorComponent != null) {
            ((Document)this.document).addChild(ComponentWidget.component((Component)this.errorComponent).addId("error"));
            return;
        }
        boolean hasCustomIconPermission = this.info != null && this.info.hasPermission(GlobalPermission.CUSTOM_ICON);
        FlexibleContentWidget container = (FlexibleContentWidget)new FlexibleContentWidget().addId("container");
        FlexibleContentWidget previewWrapper = new FlexibleContentWidget();
        ComponentWidget previewComponent = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.settings.account.iconSelector.heading.preview").addId("heading");
        previewWrapper.addContent((Widget)previewComponent);
        previewWrapper.addContent((Widget)this.previewWidget);
        FlexibleContentWidget uploadWrapper = new FlexibleContentWidget();
        FlexibleContentWidget dropdownWrapper = new FlexibleContentWidget();
        ComponentWidget dropdownComponent = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.settings.account.iconSelector.heading.dropdown").addId("heading");
        DropdownWidget iconDropdown = new DropdownWidget();
        for (GlobalIcon icon2 : GlobalIcon.values()) {
            iconDropdown.add((Object)icon2);
        }
        iconDropdown.setTranslationKeyPrefix("globaltags.settings.account.iconSelector.entries");
        iconDropdown.setSelected((Object)((GlobalIcon)this.config.icon().get()));
        uploadWrapper.setVisible(iconDropdown.getSelected() == GlobalIcon.CUSTOM);
        iconDropdown.setChangeListener(icon -> {
            uploadWrapper.setVisible(icon == GlobalIcon.CUSTOM);
            String iconUrl = TagPreviewWidget.getIconUrl(this.info, icon);
            this.previewWidget.updateGlobalIcon(iconUrl != null ? Icon.url((String)iconUrl) : null);
            Debounce.of((String)"globaltags-icon-chooser", (long)2000L, () -> {
                this.config.icon().set((Object)((GlobalIcon)iconDropdown.getSelected()));
                Util.notify((Component)Component.translatable((String)"globaltags.settings.account.save.title", (Component[])new Component[0]), (Component)Component.translatable((String)"globaltags.settings.account.save.description", (Component[])new Component[]{Component.translatable((String)"globaltags.settings.account.updateSettings.name", (Component[])new Component[0])}));
            });
        });
        ComponentWidget uploadComponent = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.settings.account.iconSelector.heading.uploader").addId("heading");
        ButtonWidget uploadButton = ButtonWidget.i18n((String)"globaltags.settings.account.iconSelector.selector.button", (Icon)Textures.SpriteCommon.PICTURE, () -> Laby.references().fileDialogs().open(I18n.translate((String)"globaltags.settings.account.iconSelector.selector.title", (Object[])new Object[0]), Path.of("/", new String[0]), I18n.translate((String)"globaltags.settings.account.iconSelector.selector.description", (Object[])new Object[0]), new String[]{"png"}, false, paths -> {
            if (((Path[])paths).length != 1) {
                return;
            }
            try {
                this.uploadIcon(paths[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        uploadButton.setHoverComponent((Component)Component.translatable((String)("globaltags.settings.account.iconSelector.selector.hover." + (hasCustomIconPermission ? "note" : "noPermission")), (TextColor)(hasCustomIconPermission ? NamedTextColor.WHITE : NamedTextColor.RED)));
        uploadButton.setEnabled(hasCustomIconPermission);
        dropdownWrapper.addContent((Widget)dropdownComponent);
        dropdownWrapper.addContent((Widget)iconDropdown);
        uploadWrapper.addContent((Widget)uploadComponent);
        uploadWrapper.addContent((Widget)uploadButton);
        if (hasCustomIconPermission && (!OperatingSystem.isOSX() || Laby.labyAPI().labyModLoader().isAddonDevelopmentEnvironment())) {
            uploadWrapper.addContent(ComponentWidget.i18n((String)"globaltags.settings.account.iconSelector.selector.hint").addId("hint"));
        }
        container.addContent((Widget)previewWrapper);
        container.addContent((Widget)dropdownWrapper);
        container.addContent((Widget)uploadWrapper);
        ((Document)this.document).addChild((Widget)container);
    }

    public boolean fileDropped(MutableMouse mouse, List<Path> paths) {
        Path path;
        String fileName;
        if (!paths.isEmpty() && (fileName = (path = paths.getFirst()).getFileName().toString()).endsWith(".png")) {
            try {
                this.uploadIcon(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return super.fileDropped(mouse, paths);
    }

    private void uploadIcon(Path path) throws IOException {
        GlobalTagsAddon.getAPI().getApiHandler().uploadIcon(this.info.getUUID(), path, response -> {
            if (!response.isSuccessful()) {
                Util.notify(I18n.translate((String)"globaltags.general.error", (Object[])new Object[0]), response.getError());
                return;
            }
            IconUploadSchema data = (IconUploadSchema)response.getData();
            Util.notify(I18n.translate((String)"globaltags.general.success", (Object[])new Object[0]), data.getMessage());
            this.previewWidget.updateGlobalIcon(GlobalIcon.CUSTOM, this.info.getUUID(), data.getHash());
            Util.broadcastTagUpdate();
        });
    }
}

