/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.activities.interaction;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.api.Util;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.wrapper.http.ApiResponse;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.CheckBoxWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;

@Link(value="input.lss")
@AutoActivity
public class BanActivity
extends SimpleActivity {
    private final GlobalTagAPI api = GlobalTagsAddon.getAPI();
    private final UUID uuid;
    private final String username;

    public BanActivity(UUID uuid, String username) {
        this.uuid = uuid;
        this.username = username;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget windowWidget = (FlexibleContentWidget)new FlexibleContentWidget().addId("window");
        HorizontalListWidget profileWrapper = (HorizontalListWidget)new HorizontalListWidget().addId(new String[]{"header", "ban-header"});
        IconWidget headIcon = (IconWidget)new IconWidget(Icon.head((UUID)this.uuid)).addId("head");
        ComponentWidget titleComponent = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.context.ban.title", (Object[])new Object[]{this.username}).addId("username");
        VerticalListWidget content = (VerticalListWidget)new VerticalListWidget().addId("content");
        ComponentWidget reasonLabelComponent = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.context.reason").addId("label");
        TextFieldWidget reasonInput = (TextFieldWidget)new TextFieldWidget().placeholder((Component)Component.translatable((String)"globaltags.context.placeholder", (TextColor)NamedTextColor.DARK_GRAY)).addId("input");
        ComponentWidget durationLabelComponent = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.context.ban.duration.title").addId("label");
        TextFieldWidget durationInput = (TextFieldWidget)new TextFieldWidget().placeholder((Component)Component.translatable((String)"globaltags.context.ban.duration.placeholder", (TextColor)NamedTextColor.DARK_GRAY)).addId("input");
        HorizontalListWidget checkboxWrapper = (HorizontalListWidget)new HorizontalListWidget().addId("checkbox-wrapper");
        CheckBoxWidget appealableCheckbox = (CheckBoxWidget)new CheckBoxWidget().addId("check-box");
        appealableCheckbox.setState(CheckBoxWidget.State.CHECKED);
        ComponentWidget checkboxLabel = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.context.editBan.appealable").addId("checkbox-label");
        ButtonWidget sendButton = (ButtonWidget)new ButtonWidget().updateComponent((Component)Component.translatable((String)"globaltags.context.ban.send", (TextColor)NamedTextColor.RED)).addId("send-button");
        sendButton.setEnabled(false);
        sendButton.setActionListener(() -> {
            Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)null);
            long duration = this.getDuration(durationInput.getText());
            this.api.getApiHandler().banPlayer(this.uuid, reasonInput.getText(), Boolean.valueOf(appealableCheckbox.state() == CheckBoxWidget.State.CHECKED), duration != -1L ? Long.valueOf(duration) : null, response -> {
                if (response.isSuccessful()) {
                    Util.broadcastTagUpdate(this.uuid);
                }
                Laby.references().chatExecutor().displayClientMessage(((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append(Util.getResponseComponent((ApiResponse<String>)response)));
            });
        });
        Runnable updateButtonVisibility = () -> sendButton.setEnabled(!reasonInput.getText().isBlank() && (durationInput.getText().isBlank() || this.getDuration(durationInput.getText()) != -1L));
        reasonInput.updateListener(text -> updateButtonVisibility.run());
        durationInput.updateListener(text -> updateButtonVisibility.run());
        profileWrapper.addEntry((Widget)headIcon);
        profileWrapper.addEntry((Widget)titleComponent);
        checkboxWrapper.addEntry((Widget)appealableCheckbox);
        checkboxWrapper.addEntry((Widget)checkboxLabel);
        content.addChild((Widget)reasonLabelComponent);
        content.addChild((Widget)reasonInput);
        content.addChild((Widget)durationLabelComponent);
        content.addChild((Widget)durationInput);
        content.addChild((Widget)checkboxWrapper);
        content.addChild((Widget)sendButton);
        windowWidget.addContent((Widget)profileWrapper);
        windowWidget.addContent((Widget)content);
        ((Document)this.document).addChild((Widget)windowWidget);
    }

    private long getDuration(String timeArg) {
        long duration;
        String format;
        try {
            format = timeArg.substring(timeArg.length() - 1);
            duration = Integer.parseInt(timeArg.substring(0, timeArg.length() - 1));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return -1L;
        }
        return switch (format) {
            case "s" -> duration * 1000L;
            case "m" -> duration * 1000L * 60L;
            case "h" -> duration * 1000L * 60L * 60L;
            case "d" -> duration * 1000L * 60L * 60L * 24L;
            case "w" -> duration * 1000L * 60L * 60L * 24L * 7L;
            case "y" -> duration * 1000L * 60L * 60L * 24L * 7L * 52L;
            default -> -1L;
        };
    }
}

