/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.activities.interaction;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.api.Util;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.wrapper.http.ApiResponse;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;

@Link(value="input.lss")
@AutoActivity
public class ChangeTagActivity
extends SimpleActivity {
    private final GlobalTagAPI api = GlobalTagsAddon.getAPI();
    private final UUID uuid;
    private final String username;

    public ChangeTagActivity(UUID uuid, String username) {
        this.uuid = uuid;
        this.username = username;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        this.api.getCache().resolve(this.uuid, info -> {
            if (info == null) {
                Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)null);
                return;
            }
            FlexibleContentWidget windowWidget = (FlexibleContentWidget)new FlexibleContentWidget().addId("window");
            HorizontalListWidget profileWrapper = (HorizontalListWidget)new HorizontalListWidget().addId("header");
            IconWidget headWidget = (IconWidget)new IconWidget(Icon.head((UUID)this.uuid)).addId("head");
            ComponentWidget titleWidget = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.context.changeTag.title", (Object[])new Object[]{this.username}).addId("username");
            VerticalListWidget content = (VerticalListWidget)new VerticalListWidget().addId("content");
            ComponentWidget labelWidget = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.context.changeTag.label").addId("label");
            TextFieldWidget inputWidget = (TextFieldWidget)new TextFieldWidget().placeholder((Component)Component.translatable((String)"globaltags.context.changeTag.placeholder", (TextColor)NamedTextColor.DARK_GRAY)).addId("input");
            boolean hasTag = !info.getPlainTag().isBlank();
            inputWidget.setText(hasTag ? info.getPlainTag() : "");
            ButtonWidget sendButton = (ButtonWidget)new ButtonWidget().updateComponent((Component)Component.translatable((String)"globaltags.context.changeTag.send", (TextColor)NamedTextColor.AQUA)).addId("send-button");
            sendButton.setEnabled(!inputWidget.getText().isBlank() && (!hasTag || !inputWidget.getText().equals(info.getPlainTag())));
            sendButton.setActionListener(() -> {
                Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)null);
                this.api.getApiHandler().setTag(this.uuid, inputWidget.getText(), response -> {
                    if (response.isSuccessful()) {
                        Util.broadcastTagUpdate(this.uuid);
                    }
                    Laby.references().chatExecutor().displayClientMessage(((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append(Util.getResponseComponent((ApiResponse<String>)response)));
                });
            });
            inputWidget.updateListener(text -> sendButton.setEnabled(!text.isBlank() && (!hasTag || !inputWidget.getText().equals(info.getPlainTag()))));
            profileWrapper.addEntry((Widget)headWidget);
            profileWrapper.addEntry((Widget)titleWidget);
            content.addChild((Widget)labelWidget);
            content.addChild((Widget)inputWidget);
            content.addChild((Widget)sendButton);
            windowWidget.addContent((Widget)profileWrapper);
            windowWidget.addContent((Widget)content);
            ((Document)this.document).addChild((Widget)windowWidget);
        });
    }
}

