/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.activities.interaction;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.api.Util;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.core.config.GlobalTagsConfig;
import com.rappytv.globaltags.wrapper.http.ApiResponse;
import java.util.UUID;
import java.util.function.Consumer;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.TranslatableComponent;
import net.labymod.api.client.component.event.ClickEvent;
import net.labymod.api.client.component.event.HoverEvent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.ScreenInstance;
import net.labymod.api.client.gui.screen.activity.AutoActivity;
import net.labymod.api.client.gui.screen.activity.Link;
import net.labymod.api.client.gui.screen.activity.types.SimpleActivity;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.activity.Document;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.CheckBoxWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.TextFieldWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.FlexibleContentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.HorizontalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.layout.list.VerticalListWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;

@Link(value="input.lss")
@AutoActivity
public class ReportActivity
extends SimpleActivity {
    private final GlobalTagsConfig config;
    private final GlobalTagAPI api;
    private final UUID uuid;
    private final String username;

    public ReportActivity(GlobalTagsConfig config, UUID uuid, String username) {
        this.config = config;
        this.api = GlobalTagsAddon.getAPI();
        this.uuid = uuid;
        this.username = username;
    }

    public void initialize(Parent parent) {
        super.initialize(parent);
        FlexibleContentWidget windowWidget = (FlexibleContentWidget)new FlexibleContentWidget().addId("window");
        HorizontalListWidget profileWrapper = (HorizontalListWidget)new HorizontalListWidget().addId("header");
        IconWidget headWidget = (IconWidget)new IconWidget(Icon.head((UUID)this.uuid)).addId("head");
        ComponentWidget titleWidget = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.context.report.title", (Object[])new Object[]{this.username}).addId("username");
        VerticalListWidget content = (VerticalListWidget)new VerticalListWidget().addId("content");
        ComponentWidget labelWidget = (ComponentWidget)ComponentWidget.i18n((String)"globaltags.context.reason").addId("label");
        TextFieldWidget inputWidget = (TextFieldWidget)new TextFieldWidget().placeholder((Component)Component.translatable((String)"globaltags.context.placeholder", (TextColor)NamedTextColor.DARK_GRAY)).addId("input");
        HorizontalListWidget ruleCheckBoxWrapper = (HorizontalListWidget)new HorizontalListWidget().addId("checkbox-wrapper");
        CheckBoxWidget ruleCheckBoxWidget = (CheckBoxWidget)new CheckBoxWidget().addId("check-box");
        ruleCheckBoxWidget.setState(CheckBoxWidget.State.UNCHECKED);
        TranslatableComponent ruleCheckBoxLabel = Component.translatable((String)"globaltags.context.report.checkbox.label", (TextColor)NamedTextColor.WHITE, (Component[])new Component[]{((TranslatableComponent)((TranslatableComponent)Component.translatable((String)"globaltags.context.report.checkbox.rules", (Component[])new Component[0]).color(NamedTextColor.AQUA)).hoverEvent(HoverEvent.showText((Component)Component.translatable((String)"globaltags.context.report.checkbox.hover", (Component[])new Component[0])))).clickEvent(ClickEvent.openUrl((String)"https://docs.globaltags.xyz/rules"))});
        ComponentWidget ruleCheckBoxLabelWidget = (ComponentWidget)ComponentWidget.component((Component)ruleCheckBoxLabel).addId("checkbox-label");
        HorizontalListWidget hideCheckBoxWrapper = (HorizontalListWidget)new HorizontalListWidget().addId("checkbox-wrapper");
        CheckBoxWidget hideCheckBoxWidget = (CheckBoxWidget)new CheckBoxWidget().addId("check-box");
        hideCheckBoxWidget.setState(CheckBoxWidget.State.CHECKED);
        TranslatableComponent hideCheckBoxLabel = Component.translatable((String)"globaltags.context.report.hide.label", (TextColor)NamedTextColor.WHITE);
        ComponentWidget hideCheckBoxLabelWidget = (ComponentWidget)ComponentWidget.component((Component)hideCheckBoxLabel).addId("checkbox-label");
        ButtonWidget sendButton = (ButtonWidget)new ButtonWidget().updateComponent((Component)Component.translatable((String)"globaltags.context.report.send", (TextColor)NamedTextColor.RED)).addId("send-button");
        sendButton.setEnabled(false);
        sendButton.setActionListener(() -> {
            Laby.labyAPI().minecraft().minecraftWindow().displayScreen((ScreenInstance)null);
            if (hideCheckBoxWidget.state() == CheckBoxWidget.State.CHECKED) {
                this.config.hiddenTags().add(this.uuid);
            }
            this.api.getApiHandler().reportPlayer(this.uuid, inputWidget.getText(), response -> Laby.references().chatExecutor().displayClientMessage(((TextComponent)Component.empty().append(GlobalTagsAddon.prefix())).append(Util.getResponseComponent((ApiResponse<String>)response))));
        });
        Consumer<String> updateButton = text -> sendButton.setEnabled(!text.isBlank() && ruleCheckBoxWidget.state() == CheckBoxWidget.State.CHECKED);
        inputWidget.updateListener(updateButton);
        ruleCheckBoxWidget.setActionListener(() -> updateButton.accept(inputWidget.getText()));
        profileWrapper.addEntry((Widget)headWidget);
        profileWrapper.addEntry((Widget)titleWidget);
        ruleCheckBoxWrapper.addEntry((Widget)ruleCheckBoxWidget);
        ruleCheckBoxWrapper.addEntry((Widget)ruleCheckBoxLabelWidget);
        hideCheckBoxWrapper.addEntry((Widget)hideCheckBoxWidget);
        hideCheckBoxWrapper.addEntry((Widget)hideCheckBoxLabelWidget);
        content.addChild((Widget)labelWidget);
        content.addChild((Widget)inputWidget);
        content.addChild((Widget)ruleCheckBoxWrapper);
        content.addChild((Widget)hideCheckBoxWrapper);
        content.addChild((Widget)sendButton);
        windowWidget.addContent((Widget)profileWrapper);
        windowWidget.addContent((Widget)content);
        ((Document)this.document).addChild((Widget)windowWidget);
    }
}

