/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.nametag;

import com.rappytv.globaltags.core.ui.snapshot.GlobalTagsExtraKeys;
import com.rappytv.globaltags.core.ui.snapshot.GlobalTagsUserSnapshot;
import com.rappytv.globaltags.wrapper.enums.GlobalPosition;
import com.rappytv.globaltags.wrapper.model.PlayerInfo;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.entity.player.tag.PositionType;
import net.labymod.api.client.entity.player.tag.tags.ComponentNameTag;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.render.matrix.Stack;
import net.labymod.api.client.render.state.entity.EntitySnapshot;
import net.labymod.api.laby3d.render.queue.SubmissionCollector;
import net.labymod.api.laby3d.render.queue.submissions.IconSubmission;
import org.jetbrains.annotations.NotNull;

public class GlobalTagNameTag
extends ComponentNameTag {
    private static final float globalIconSize = 9.0f;
    private static final float staffIconSize = 11.0f;
    private final PositionType registeredPosition;
    private final Supplier<Float> scaleSupplier;
    private GlobalTagsUserSnapshot globaltagsUser;

    public GlobalTagNameTag(PositionType position, Supplier<Float> scaleSupplier) {
        this.registeredPosition = position;
        this.scaleSupplier = scaleSupplier;
    }

    public float getScale() {
        return this.scaleSupplier.get().floatValue();
    }

    @NotNull
    protected List<Component> buildComponents(EntitySnapshot snapshot) {
        if (snapshot.isDiscrete() || snapshot.isInvisible() || !snapshot.has(GlobalTagsExtraKeys.GLOBALTAGS_USER)) {
            return super.buildComponents(snapshot);
        }
        this.globaltagsUser = (GlobalTagsUserSnapshot)((Object)snapshot.get(GlobalTagsExtraKeys.GLOBALTAGS_USER));
        PlayerInfo<Component> info = this.globaltagsUser.getPlayerInfo();
        if (!this.globaltagsUser.isAddonEnabled() || info == null || info.getTag() == null || !this.getGlobalPosition(this.registeredPosition).equals((Object)info.getPosition()) || this.globaltagsUser.isHidden()) {
            return super.buildComponents(snapshot);
        }
        return Collections.singletonList((Component)info.getTag());
    }

    public void render(Stack stack, SubmissionCollector submissionCollector, EntitySnapshot snapshot) {
        Icon staffIcon;
        super.render(stack, submissionCollector, snapshot);
        PlayerInfo<Component> info = this.globaltagsUser.getPlayerInfo();
        if (info == null) {
            return;
        }
        if (info.hasGlobalIcon()) {
            submissionCollector.submitIcon(stack, Icon.url((String)Objects.requireNonNull(info.getIconUrl())), IconSubmission.DisplayMode.NORMAL, -11.0f, -1.0f, 9.0f, 9.0f, -1);
        }
        if ((staffIcon = this.globaltagsUser.getStaffIcon()) != null) {
            submissionCollector.submitIcon(stack, staffIcon, IconSubmission.DisplayMode.NORMAL, this.getWidth() + 0.9f, -1.8f, 11.0f, 11.0f, -1);
        }
    }

    private GlobalPosition getGlobalPosition(PositionType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PositionType.ABOVE_NAME -> GlobalPosition.ABOVE;
            case PositionType.BELOW_NAME -> GlobalPosition.BELOW;
            case PositionType.RIGHT_TO_NAME -> GlobalPosition.RIGHT;
            case PositionType.LEFT_TO_NAME -> GlobalPosition.LEFT;
        };
    }
}

