/*
 * Decompiled with CFR 0.152.
 */
package com.rappytv.globaltags.core.ui.widgets.interaction;

import com.rappytv.globaltags.api.GlobalTagAPI;
import com.rappytv.globaltags.api.Util;
import com.rappytv.globaltags.core.GlobalTagsAddon;
import com.rappytv.globaltags.wrapper.http.ApiResponse;
import com.rappytv.globaltags.wrapper.model.PlayerNote;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.TextComponent;
import net.labymod.api.client.component.format.NamedTextColor;
import net.labymod.api.client.component.format.TextColor;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.gui.lss.property.annotation.AutoWidget;
import net.labymod.api.client.gui.screen.Parent;
import net.labymod.api.client.gui.screen.widget.SimpleWidget;
import net.labymod.api.client.gui.screen.widget.Widget;
import net.labymod.api.client.gui.screen.widget.widgets.ComponentWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.renderer.IconWidget;
import net.labymod.api.util.I18n;

@AutoWidget
public class StaffNoteWidget
extends SimpleWidget {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private final UUID holder;
    private final GlobalTagAPI api;
    private final PlayerNote note;
    private ButtonWidget deleteButton;

    public StaffNoteWidget(UUID holder, GlobalTagAPI api, PlayerNote note) {
        this.holder = holder;
        this.api = api;
        this.note = note;
    }

    public void initialize(Parent parent) {
        if (this.isInitialized()) {
            return;
        }
        super.initialize(parent);
        IconWidget headWidget = (IconWidget)new IconWidget(Icon.head((UUID)this.note.getAuthor())).addId("author-head");
        ComponentWidget text = (ComponentWidget)ComponentWidget.text((String)this.note.getText()).addId("text-component");
        text.setHoverComponent((Component)Component.text((String)this.note.getText()));
        ComponentWidget description = (ComponentWidget)ComponentWidget.text((String)I18n.translate((String)"globaltags.context.staffNotes.description", (Object[])new Object[]{this.formatDate(this.note.getCreatedAt()), this.note.getId()}), (TextColor)NamedTextColor.DARK_GRAY).addId("description-component");
        this.deleteButton = (ButtonWidget)ButtonWidget.component((Component)Component.text((String)"\u2717", (TextColor)NamedTextColor.RED), this::delete).addId("delete-button");
        this.deleteButton.setHoverComponent((Component)Component.translatable((String)"globaltags.context.staffNotes.hover.delete", (TextColor)NamedTextColor.RED));
        this.addChild((Widget)headWidget);
        this.addChild((Widget)text);
        this.addChild((Widget)description);
        this.addChild((Widget)this.deleteButton);
    }

    private String formatDate(Date date) {
        return dateFormat.format(date);
    }

    private void delete() {
        this.deleteButton.setEnabled(false);
        this.api.getApiHandler().deleteNote(this.holder, this.note.getId(), response -> {
            Laby.references().chatExecutor().displayClientMessage((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().append(GlobalTagsAddon.prefix())).append(Util.getResponseComponent((ApiResponse<String>)response))).build());
            if (!response.isSuccessful()) {
                this.deleteButton.setEnabled(true);
                return;
            }
            Laby.labyAPI().minecraft().executeOnRenderThread(() -> {
                this.deleteButton.updateComponent((Component)Component.text((String)"\u2713", (TextColor)NamedTextColor.GREEN));
                this.deleteButton.setHoverComponent((Component)Component.translatable((String)"globaltags.context.staffNotes.hover.deleted", (TextColor)NamedTextColor.GREEN));
            });
        });
    }
}

