/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.network;

import de.hdskins.addon.HDSkinsAddon;
import de.hdskins.addon.network.ClientLogger;
import de.hdskins.core.api.event.CoreAuthenticatedEvent;
import de.hdskins.core.api.event.CoreUnauthenticatedEvent;
import de.hdskins.protocol.PacketRegistrar;
import de.hdskins.protocol.client.NetworkClient;
import de.hdskins.protocol.client.provider.ClientProvider;
import de.hdskins.protocol.logger.InternalLogger;
import de.hdskins.protocol.packets.HDSkinsPacketRegistrar;
import java.util.concurrent.ExecutionException;
import javax.inject.Singleton;
import net.labymod.api.Laby;
import net.labymod.api.LabyAPI;
import net.labymod.api.event.Phase;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.lifecycle.GameTickEvent;
import net.labymod.api.reference.annotation.Referenceable;
import net.labymod.api.util.logging.Logging;

@Singleton
@Referenceable
public class Network {
    private final LabyAPI labyAPI = Laby.labyAPI();
    private final ClientProvider clientProvider;
    private final Logging logger = HDSkinsAddon.instance().logger();

    public Network() {
        this.clientProvider = new ClientProvider(NetworkClient.create((String)"bridge.hdskins.de", (int)7008, (InternalLogger)new ClientLogger(), () -> ((LabyAPI)this.labyAPI).getName(), serverId -> {
            try {
                return (Boolean)this.labyAPI.minecraft().authenticator().joinServer(this.labyAPI.minecraft().sessionAccessor().getSession(), serverId).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
                return false;
            }
        }), "LabyMod_" + this.labyAPI.getVersion(), this.labyAPI.minecraft().getVersion(), 7);
        this.clientProvider.getClient().registerPackets((PacketRegistrar)new HDSkinsPacketRegistrar());
    }

    public ClientProvider getClientProvider() {
        return this.clientProvider;
    }

    public NetworkClient getClient() {
        return this.clientProvider.getClient();
    }

    @Subscribe
    public void tick(GameTickEvent event) {
        if (event.phase() == Phase.POST) {
            this.clientProvider.tick();
        }
    }

    @Subscribe
    public void connect(CoreAuthenticatedEvent event) {
        this.logger.info((CharSequence)"CoreAuthenticatedEvent was fired, handling network for addon HDSkins", new Object[0]);
        this.clientProvider.getClient().setCustomAuthHandler(event.authHandler());
        this.handleCoreConnection();
    }

    @Subscribe
    public void connect(CoreUnauthenticatedEvent event) {
        this.logger.info((CharSequence)"CoreUnauthenticatedEvent was fired, handling network for addon HDSkins", new Object[0]);
        this.handleCoreConnection();
    }

    private void handleCoreConnection() {
        if (this.clientProvider.connect()) {
            this.logger.info((CharSequence)"Connection to HDSkins network established, reloading all skins", new Object[0]);
            HDSkinsAddon.instance().references().skinService().reloadAllSkins();
            Laby.labyAPI().interactionMenuRegistry().unregister("hdskins-invite-point");
            return;
        }
        this.logger.error((CharSequence)"Connection to HDSkins network failed", new Object[0]);
    }
}

