/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.settings;

import de.hdskins.addon.HDSkinsAddon;
import de.hdskins.protocol.PacketBase;
import de.hdskins.protocol.client.NetworkClient;
import de.hdskins.protocol.concurrent.FutureListener;
import de.hdskins.protocol.packets.core.dashboard.PacketClientRequestDashboardUrl;
import de.hdskins.protocol.packets.core.dashboard.PacketServerResponseDashboardUrl;
import net.labymod.api.Laby;
import net.labymod.api.addon.AddonConfig;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.gui.screen.widget.widgets.input.ButtonWidget;
import net.labymod.api.client.gui.screen.widget.widgets.input.SwitchWidget;
import net.labymod.api.configuration.loader.annotation.ConfigName;
import net.labymod.api.configuration.loader.annotation.SpriteSlot;
import net.labymod.api.configuration.loader.annotation.SpriteTexture;
import net.labymod.api.configuration.loader.property.ConfigProperty;
import net.labymod.api.configuration.settings.annotation.SettingSection;
import net.labymod.api.notification.Notification;
import net.labymod.api.util.MethodOrder;
import org.jetbrains.annotations.NotNull;

@ConfigName(value="hdskins")
@SpriteTexture(value="settings")
public class HDSkinsSettings
extends AddonConfig {
    @SwitchWidget.SwitchSetting
    @SpriteSlot(size=32, x=2)
    private final ConfigProperty<Boolean> enabled = new ConfigProperty((Object)true);
    @SwitchWidget.SwitchSetting
    @MethodOrder(after="enabled")
    @SpriteSlot(size=32, y=1)
    private final ConfigProperty<Boolean> staffTags = new ConfigProperty((Object)true);
    @SwitchWidget.SwitchSetting
    @MethodOrder(after="reloadSkins")
    @SpriteSlot(size=32, x=1, y=1)
    private final ConfigProperty<Boolean> onlineStatus = new ConfigProperty((Object)true).visibilitySupplier(() -> HDSkinsAddon.instance().references().staffOnlineStatusStorage().isAllowToDisplayOnlineUsers());

    @SpriteSlot(size=32, x=1)
    @MethodOrder(after="staffTags")
    @ButtonWidget.ButtonSetting
    public void reloadSkins() {
        HDSkinsAddon.instance().references().skinService().reloadAllSkins();
    }

    @SettingSection(value="services")
    @SpriteSlot(size=32)
    @MethodOrder(after="onlineStatus")
    @ButtonWidget.ButtonSetting
    public void openDashboard() {
        NetworkClient client = HDSkinsAddon.instance().references().network().getClient();
        if (!client.isConnected()) {
            Notification notification = Notification.builder().title((Component)Component.translatable((String)"hdskins.settings.name", (Component[])new Component[0])).text((Component)Component.translatable((String)"hdskins.not-connected", (Component[])new Component[0])).type(Notification.Type.SYSTEM).duration(5000L).buildAndPush();
            return;
        }
        client.sendQuery((PacketBase)new PacketClientRequestDashboardUrl()).addListener((FutureListener)new FutureListener<PacketBase>(this){

            public void nullResult() {
                HDSkinsAddon.instance().logger().warn((CharSequence)"Received null response from server while requesting dashboard URL", new Object[0]);
            }

            public void nonNullResult(@NotNull PacketBase packetBase) {
                PacketServerResponseDashboardUrl packet = (PacketServerResponseDashboardUrl)packetBase;
                Laby.labyAPI().minecraft().chatExecutor().openUrl(packet.getUrl());
                HDSkinsAddon.instance().logger().info((CharSequence)"Received dashboard URL from server", new Object[0]);
            }

            public void cancelled() {
                HDSkinsAddon.instance().logger().warn((CharSequence)"Requesting dashboard URL was cancelled", new Object[0]);
            }
        });
    }

    @SpriteSlot(x=3, size=32)
    @MethodOrder(after="openDashboard")
    @ButtonWidget.ButtonSetting
    public void openDiscord() {
        Laby.labyAPI().minecraft().chatExecutor().openUrl("https://discord.hdskins.de/", false);
    }

    public ConfigProperty<Boolean> enabled() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    public boolean showStaffTags() {
        return this.isEnabled() && (Boolean)this.staffTags.get() != false;
    }

    public boolean isOnlineStatusEnabled() {
        return (Boolean)this.enabled.get() != false && (Boolean)this.onlineStatus.get() != false;
    }
}

