/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.tag;

import de.hdskins.addon.network.Network;
import de.hdskins.protocol.listener.PacketListener;
import de.hdskins.protocol.packets.core.tag.PacketServerUpdateTeamTag;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.component.serializer.legacy.LegacyComponentSerializer;
import net.labymod.api.client.render.font.RenderableComponent;
import net.labymod.api.reference.annotation.Referenceable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Referenceable
public class TeamTagStorage {
    private final Map<UUID, RenderableComponent> teamTags = new ConcurrentHashMap<UUID, RenderableComponent>();

    public TeamTagStorage(Network network) {
        network.getClient().getPacketListenerRegistry().registerListeners((Object)this);
    }

    @PacketListener
    public void storeNameTag(PacketServerUpdateTeamTag packet) {
        String tag = packet.getTag();
        if (tag == null) {
            this.teamTags.remove(packet.getUniqueId());
            return;
        }
        this.teamTags.put(packet.getUniqueId(), RenderableComponent.of((Component)LegacyComponentSerializer.legacySection().deserialize(tag)));
    }

    @Nullable
    public RenderableComponent getTag(@NotNull UUID uniqueId) {
        return this.teamTags.getOrDefault(uniqueId, null);
    }

    public void removeTag(@NotNull UUID uniqueId) {
        this.teamTags.remove(uniqueId);
    }

    public void removeAll() {
        this.teamTags.clear();
    }
}

