/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.report;

import de.hdskins.addon.network.Network;
import de.hdskins.protocol.PacketBase;
import de.hdskins.protocol.packets.core.report.PacketClientReportUser;
import de.hdskins.protocol.packets.texture.TextureType;
import java.util.UUID;
import net.labymod.api.Laby;
import net.labymod.api.client.component.Component;
import net.labymod.api.client.entity.player.Player;
import net.labymod.api.client.entity.player.interaction.AbstractBulletPoint;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.notification.Notification;

public class ReportSkinBulletPoint
extends AbstractBulletPoint {
    private final Network network;

    public ReportSkinBulletPoint(Network network) {
        super((Component)Component.translatable((String)"hdskins.report.interactionName", (Component[])new Component[0]));
        this.network = network;
    }

    public void execute(Player player) {
        if (!this.network.getClient().isConnected()) {
            Notification notification = Notification.builder().title((Component)Component.translatable((String)"hdskins.report.title", (Component[])new Component[0])).text((Component)Component.translatable((String)"hdskins.not-connected", (Component[])new Component[0])).type(Notification.Type.SYSTEM).duration(5000L).build();
            Laby.labyAPI().minecraft().executeOnRenderThread(() -> Laby.references().notificationController().push(notification));
            return;
        }
        this.network.getClient().sendPacket((PacketBase)new PacketClientReportUser(player.getUniqueId(), TextureType.SKIN));
        Notification notification = Notification.builder().title((Component)Component.translatable((String)"hdskins.report.title", (Component[])new Component[0])).text((Component)Component.translatable((String)"hdskins.report.reported", (Component[])new Component[]{Component.text((String)player.getName())})).icon(Icon.head((UUID)player.getUniqueId())).type(Notification.Type.SYSTEM).duration(5000L).build();
        Laby.labyAPI().minecraft().executeOnRenderThread(() -> Laby.references().notificationController().push(notification));
    }

    public boolean isVisible(Player playerInfo) {
        return playerInfo.skinTexture().getNamespace().equals("hdskins");
    }
}

