/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon.skin;

import de.hdskins.addon.HDSkinsAddon;
import de.hdskins.addon.skin.SkinService;
import de.hdskins.addon.tag.TeamTagStorage;
import net.labymod.api.event.Subscribe;
import net.labymod.api.event.client.network.playerinfo.PlayerInfoAddEvent;
import net.labymod.api.event.client.network.playerinfo.PlayerInfoRemoveEvent;
import net.labymod.api.event.client.network.server.ServerDisconnectEvent;
import net.labymod.api.reference.annotation.Referenceable;

@Referenceable
public class SkinListeners {
    private final SkinService skinService = HDSkinsAddon.instance().references().skinService();
    private final TeamTagStorage teamTagStorage = HDSkinsAddon.instance().references().teamTagStorage();

    @Subscribe
    public void onAdd(PlayerInfoAddEvent event) {
        this.skinService.loadSkin(event.playerInfo());
    }

    @Subscribe
    public void onRemove(PlayerInfoRemoveEvent event) {
        this.skinService.handlePlayerQuit(event.playerInfo());
        this.teamTagStorage.removeTag(event.playerInfo().profile().getUniqueId());
    }

    @Subscribe
    public void onDisconnect(ServerDisconnectEvent event) {
        this.skinService.handleRemoveAll();
        this.teamTagStorage.removeAll();
    }
}

