/*
 * Decompiled with CFR 0.152.
 */
package de.hdskins.addon;

import de.hdskins.addon.core.generated.DefaultReferenceStorage;
import de.hdskins.addon.report.ReportSkinBulletPoint;
import de.hdskins.addon.settings.HDSkinsSettings;
import de.hdskins.addon.tag.TeamTagRenderer;
import de.hdskins.addon.tag.online.HDSkinsBadge;
import de.hdskins.addon.tag.online.HDSkinsTag;
import javax.inject.Singleton;
import net.labymod.api.Laby;
import net.labymod.api.addon.LabyAddon;
import net.labymod.api.client.entity.player.badge.PositionType;
import net.labymod.api.client.entity.player.badge.renderer.BadgeRenderer;
import net.labymod.api.client.entity.player.tag.renderer.TagRenderer;
import net.labymod.api.client.gui.icon.Icon;
import net.labymod.api.client.resources.ResourceLocation;
import net.labymod.api.client.resources.texture.TextureLoader;
import net.labymod.api.models.addon.annotation.AddonMain;
import net.labymod.api.reference.annotation.Referenceable;

@AddonMain
@Singleton
@Referenceable
public class HDSkinsAddon
extends LabyAddon<HDSkinsSettings> {
    private static HDSkinsAddon instance;

    protected void enable() {
        instance = this;
        this.registerSettingCategory();
        this.registerListener(this.references().network());
        this.registerListener(this.references().skinListeners());
        this.registerListener(this.references().notificationListener());
        this.registerListener((Object)this.references().inviteHandler());
        this.registerOnlineBadges();
        Laby.labyAPI().interactionMenuRegistry().register((Object)new ReportSkinBulletPoint(this.references().network()));
        Laby.labyAPI().tagRegistry().registerBefore("labymod_role", "hdskins_role", net.labymod.api.client.entity.player.tag.PositionType.ABOVE_NAME, (TagRenderer)new TeamTagRenderer(this.references().teamTagStorage()));
        Laby.references().textureRepository().registerTextureLoader(400, (TextureLoader)this.references().hdTexturesLoader());
    }

    private void registerOnlineBadges() {
        this.references().network().getClient().getPacketListenerRegistry().registerListeners((Object)this.references().staffOnlineStatusStorage());
        Icon icon = Icon.texture((ResourceLocation)ResourceLocation.create((String)"hdskins", (String)"textures/icon.png"));
        Laby.labyAPI().tagRegistry().registerBefore("VoiceTag", "hdskins_online_tag", net.labymod.api.client.entity.player.tag.PositionType.RIGHT_TO_NAME, (TagRenderer)new HDSkinsTag(this, icon));
        Laby.references().badgeRegistry().registerBefore("VoiceBadge", "hdskins_online_badge", PositionType.RIGHT_TO_NAME, (BadgeRenderer)new HDSkinsBadge(this, icon));
    }

    public DefaultReferenceStorage references() {
        return (DefaultReferenceStorage)this.referenceStorageAccessor();
    }

    protected Class<? extends HDSkinsSettings> configurationClass() {
        return HDSkinsSettings.class;
    }

    public static HDSkinsAddon instance() {
        return instance;
    }
}

